/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonObject;
import org.redisson.api.RFuture;
import org.redisson.api.RRateLimiter;
import org.redisson.api.RateIntervalUnit;
import org.redisson.api.RateType;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;

public class RedissonRateLimiter
extends RedissonObject
implements RRateLimiter {
    public RedissonRateLimiter(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    String getValueName() {
        return RedissonRateLimiter.suffixName(this.getName(), "value");
    }

    String getClientValueName() {
        return RedissonRateLimiter.suffixName(this.getValueName(), this.commandExecutor.getConnectionManager().getId().toString());
    }

    @Override
    public boolean tryAcquire() {
        return this.tryAcquire(1L);
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync() {
        return this.tryAcquireAsync(1L);
    }

    @Override
    public boolean tryAcquire(long permits) {
        return this.get(this.tryAcquireAsync(RedisCommands.EVAL_NULL_BOOLEAN, permits));
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync(long permits) {
        return this.tryAcquireAsync(RedisCommands.EVAL_NULL_BOOLEAN, permits);
    }

    @Override
    public void acquire() {
        this.get(this.acquireAsync());
    }

    @Override
    public RFuture<Void> acquireAsync() {
        return this.acquireAsync(1L);
    }

    @Override
    public void acquire(long permits) {
        this.get(this.acquireAsync(permits));
    }

    @Override
    public RFuture<Void> acquireAsync(long permits) {
        final RedissonPromise<Void> promise = new RedissonPromise<Void>();
        this.tryAcquireAsync(permits, -1L, null).addListener(new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.tryFailure(future.cause());
                    return;
                }
                promise.trySuccess(null);
            }
        });
        return promise;
    }

    @Override
    public boolean tryAcquire(long timeout, TimeUnit unit) {
        return this.get(this.tryAcquireAsync(timeout, unit));
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync(long timeout, TimeUnit unit) {
        return this.tryAcquireAsync(1L, timeout, unit);
    }

    @Override
    public boolean tryAcquire(long permits, long timeout, TimeUnit unit) {
        return this.get(this.tryAcquireAsync(permits, timeout, unit));
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync(long permits, long timeout, TimeUnit unit) {
        RedissonPromise<Boolean> promise = new RedissonPromise<Boolean>();
        long timeoutInMillis = -1L;
        if (timeout > 0L) {
            timeoutInMillis = unit.toMillis(timeout);
        }
        this.tryAcquireAsync(permits, promise, timeoutInMillis);
        return promise;
    }

    private void tryAcquireAsync(final long permits, final RPromise<Boolean> promise, final long timeoutInMillis) {
        final long start = System.currentTimeMillis();
        RFuture<Long> future = this.tryAcquireAsync(RedisCommands.EVAL_LONG, permits);
        future.addListener(new FutureListener<Long>(){

            @Override
            public void operationComplete(Future<Long> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.tryFailure(future.cause());
                    return;
                }
                Long delay = future.getNow();
                if (delay == null) {
                    promise.trySuccess(true);
                    return;
                }
                if (timeoutInMillis == -1L) {
                    RedissonRateLimiter.this.commandExecutor.getConnectionManager().getGroup().schedule(new Runnable(){

                        @Override
                        public void run() {
                            RedissonRateLimiter.this.tryAcquireAsync(permits, promise, timeoutInMillis);
                        }
                    }, (long)delay, TimeUnit.MILLISECONDS);
                    return;
                }
                long elapsed = System.currentTimeMillis() - start;
                final long remains = timeoutInMillis - elapsed;
                if (remains <= 0L) {
                    promise.trySuccess(false);
                    return;
                }
                if (remains < delay) {
                    RedissonRateLimiter.this.commandExecutor.getConnectionManager().getGroup().schedule(new Runnable(){

                        @Override
                        public void run() {
                            promise.trySuccess(false);
                        }
                    }, remains, TimeUnit.SECONDS);
                } else {
                    final long start2 = System.currentTimeMillis();
                    RedissonRateLimiter.this.commandExecutor.getConnectionManager().getGroup().schedule(new Runnable(){

                        @Override
                        public void run() {
                            long elapsed = System.currentTimeMillis() - start2;
                            if (remains <= elapsed) {
                                promise.trySuccess(false);
                                return;
                            }
                            RedissonRateLimiter.this.tryAcquireAsync(permits, promise, remains - elapsed);
                        }
                    }, (long)delay, TimeUnit.SECONDS);
                }
            }
        });
    }

    private <T> RFuture<T> tryAcquireAsync(RedisCommand<T> command, Long value) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, command, "local rate = redis.call('hget', KEYS[1], 'rate');local interval = redis.call('hget', KEYS[1], 'interval');local type = redis.call('hget', KEYS[1], 'type');assert(rate ~= false and interval ~= false and type ~= false, 'RateLimiter is not initialized')local valueName = KEYS[2];if type == 1 then valueName = KEYS[3];end;local currentValue = redis.call('get', valueName); if currentValue ~= false then if tonumber(currentValue) < tonumber(ARGV[1]) then return redis.call('pttl', valueName); else redis.call('decrby', valueName, ARGV[1]); return nil; end; else redis.call('set', valueName, rate, 'px', interval); redis.call('decrby', valueName, ARGV[1]); return nil; end;", Arrays.asList(this.getName(), this.getValueName(), this.getClientValueName()), value, this.commandExecutor.getConnectionManager().getId().toString());
    }

    @Override
    public boolean trySetRate(RateType type, long rate, long rateInterval, RateIntervalUnit unit) {
        return this.get(this.trySetRateAsync(type, rate, rateInterval, unit));
    }

    @Override
    public RFuture<Boolean> trySetRateAsync(RateType type, long rate, long rateInterval, RateIntervalUnit unit) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "redis.call('hsetnx', KEYS[1], 'rate', ARGV[1]);redis.call('hsetnx', KEYS[1], 'interval', ARGV[2]);return redis.call('hsetnx', KEYS[1], 'type', ARGV[3]);", Collections.singletonList(this.getName()), rate, unit.toMillis(rateInterval), type.ordinal());
    }
}

