/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoNext;
import reactor.util.annotation.Nullable;

final class MonoFromPublisher<T>
extends Mono<T>
implements Scannable {
    final Publisher<? extends T> source;

    MonoFromPublisher(Publisher<? extends T> source) {
        this.source = Objects.requireNonNull(source, "publisher");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        this.source.subscribe(new MonoNext.NextSubscriber<T>(actual));
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        return null;
    }
}

