/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RStream;
import org.redisson.api.StreamId;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonStream<K, V>
extends RedissonExpirable
implements RStream<K, V> {
    public RedissonStream(Codec codec, CommandAsyncExecutor connectionManager, String name) {
        super(codec, connectionManager, name);
    }

    public RedissonStream(CommandAsyncExecutor connectionManager, String name) {
        super(connectionManager, name);
    }

    protected void checkKey(Object key) {
        if (key == null) {
            throw new NullPointerException("key can't be null");
        }
    }

    protected void checkValue(Object value) {
        if (value == null) {
            throw new NullPointerException("value can't be null");
        }
    }

    @Override
    public StreamId addAll(Map<K, V> entries) {
        return this.addAll(entries, 0, false);
    }

    @Override
    public RFuture<StreamId> addAllAsync(Map<K, V> entries) {
        return this.addAllAsync(entries, 0, false);
    }

    @Override
    public void addAll(StreamId id, Map<K, V> entries) {
        this.addAll(id, entries, 0, false);
    }

    @Override
    public RFuture<Void> addAllAsync(StreamId id, Map<K, V> entries) {
        return this.addAllAsync(id, entries, 0, false);
    }

    @Override
    public StreamId addAll(Map<K, V> entries, int trimLen, boolean trimStrict) {
        return this.get(this.addAllAsync(entries, trimLen, trimStrict));
    }

    @Override
    public RFuture<StreamId> addAllAsync(Map<K, V> entries, int trimLen, boolean trimStrict) {
        return this.addAllCustomAsync(null, entries, trimLen, trimStrict);
    }

    @Override
    public void addAll(StreamId id, Map<K, V> entries, int trimLen, boolean trimStrict) {
        this.get(this.addAllAsync(id, entries, trimLen, trimStrict));
    }

    private <R> RFuture<R> addAllCustomAsync(StreamId id, Map<K, V> entries, int trimLen, boolean trimStrict) {
        ArrayList<Object> params = new ArrayList<Object>(entries.size() * 2 + 1);
        params.add(this.getName());
        if (trimLen > 0) {
            params.add("MAXLEN");
            if (!trimStrict) {
                params.add("~");
            }
            params.add(trimLen);
        }
        if (id == null) {
            params.add("*");
        } else {
            params.add(id.toString());
        }
        for (Map.Entry<K, V> t : entries.entrySet()) {
            this.checkKey(t.getKey());
            this.checkValue(t.getValue());
            params.add(this.encodeMapKey(t.getKey()));
            params.add(this.encodeMapValue(t.getValue()));
        }
        if (id == null) {
            return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.XADD, params.toArray());
        }
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.XADD_VOID, params.toArray());
    }

    @Override
    public RFuture<Void> addAllAsync(StreamId id, Map<K, V> entries, int trimLen, boolean trimStrict) {
        return this.addAllCustomAsync(id, entries, trimLen, trimStrict);
    }

    @Override
    public long size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public RFuture<Long> sizeAsync() {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.XLEN, this.getName());
    }

    @Override
    public Map<StreamId, Map<K, V>> read(int count, StreamId ... ids) {
        return this.get(this.readAsync(count, ids));
    }

    @Override
    public RFuture<Map<String, Map<StreamId, Map<K, V>>>> readAsync(int count, Collection<String> keys, StreamId ... ids) {
        return this.readAsync(count, -1L, null, keys, ids);
    }

    @Override
    public Map<StreamId, Map<K, V>> read(int count, long timeout, TimeUnit unit, StreamId ... ids) {
        return this.get(this.readAsync(count, timeout, unit, ids));
    }

    @Override
    public RFuture<Map<String, Map<StreamId, Map<K, V>>>> readAsync(int count, long timeout, TimeUnit unit, Collection<String> keys, StreamId ... ids) {
        if (keys.size() + 1 != ids.length) {
            throw new IllegalArgumentException("keys amount should be lower by one than ids amount");
        }
        ArrayList<Object> params = new ArrayList<Object>();
        if (count > 0) {
            params.add("COUNT");
            params.add(count);
        }
        if (timeout > 0L) {
            params.add("BLOCK");
            params.add(this.toSeconds(timeout, unit) * 1000L);
        }
        params.add("STREAMS");
        params.add(this.getName());
        if (keys != null) {
            for (String key : keys) {
                params.add(key);
            }
        }
        for (StreamId id : ids) {
            params.add(id.toString());
        }
        if (timeout > 0L) {
            return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.XREAD_BLOCKING, params.toArray());
        }
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.XREAD, params.toArray());
    }

    @Override
    public RFuture<StreamId> addAsync(K key, V value) {
        return this.addAsync(key, value, 0, false);
    }

    @Override
    public RFuture<Void> addAsync(StreamId id, K key, V value) {
        return this.addAsync(id, key, value, 0, false);
    }

    @Override
    public RFuture<StreamId> addAsync(K key, V value, int trimLen, boolean trimStrict) {
        return this.addCustomAsync(null, key, value, trimLen, trimStrict);
    }

    private <R> RFuture<R> addCustomAsync(StreamId id, K key, V value, int trimLen, boolean trimStrict) {
        LinkedList<Object> params = new LinkedList<Object>();
        params.add(this.getName());
        if (trimLen > 0) {
            params.add("MAXLEN");
            if (!trimStrict) {
                params.add("~");
            }
            params.add(trimLen);
        }
        if (id == null) {
            params.add("*");
        } else {
            params.add(id.toString());
        }
        this.checkKey(key);
        this.checkValue(value);
        params.add(this.encodeMapKey(key));
        params.add(this.encodeMapValue(value));
        if (id == null) {
            return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.XADD, params.toArray());
        }
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.XADD_VOID, params.toArray());
    }

    @Override
    public RFuture<Void> addAsync(StreamId id, K key, V value, int trimLen, boolean trimStrict) {
        return this.addCustomAsync(id, key, value, trimLen, trimStrict);
    }

    @Override
    public StreamId add(K key, V value) {
        return this.get(this.addAsync(key, value));
    }

    @Override
    public void add(StreamId id, K key, V value) {
        this.get(this.addAsync(id, key, value));
    }

    @Override
    public StreamId add(K key, V value, int trimLen, boolean trimStrict) {
        return this.get(this.addAsync(key, value, trimLen, trimStrict));
    }

    @Override
    public void add(StreamId id, K key, V value, int trimLen, boolean trimStrict) {
        this.get(this.addAsync(id, key, value, trimLen, trimStrict));
    }

    @Override
    public RFuture<Map<StreamId, Map<K, V>>> readAsync(int count, StreamId ... ids) {
        return this.readAsync(count, 0L, null, ids);
    }

    @Override
    public RFuture<Map<StreamId, Map<K, V>>> readAsync(int count, long timeout, TimeUnit unit, StreamId ... ids) {
        ArrayList<Object> params = new ArrayList<Object>();
        if (count > 0) {
            params.add("COUNT");
            params.add(count);
        }
        if (timeout > 0L) {
            params.add("BLOCK");
            params.add(this.toSeconds(timeout, unit) * 1000L);
        }
        params.add("STREAMS");
        params.add(this.getName());
        for (StreamId id : ids) {
            params.add(id.toString());
        }
        if (timeout > 0L) {
            return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.XREAD_BLOCKING_SINGLE, params.toArray());
        }
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.XREAD_SINGLE, params.toArray());
    }

    @Override
    public Map<String, Map<StreamId, Map<K, V>>> read(int count, Collection<String> keys, StreamId ... ids) {
        return this.get(this.readAsync(count, keys, ids));
    }

    @Override
    public Map<String, Map<StreamId, Map<K, V>>> read(int count, long timeout, TimeUnit unit, Collection<String> keys, StreamId ... ids) {
        return this.get(this.readAsync(count, timeout, unit, keys, ids));
    }

    @Override
    public RFuture<Map<StreamId, Map<K, V>>> rangeAsync(int count, StreamId startId, StreamId endId) {
        LinkedList<Object> params = new LinkedList<Object>();
        params.add(this.getName());
        params.add(startId);
        params.add(endId);
        if (count > 0) {
            params.add("COUNT");
            params.add(count);
        }
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.XRANGE, params.toArray());
    }

    @Override
    public Map<StreamId, Map<K, V>> range(int count, StreamId startId, StreamId endId) {
        return this.get(this.rangeAsync(count, startId, endId));
    }

    @Override
    public RFuture<Map<StreamId, Map<K, V>>> rangeReversedAsync(int count, StreamId startId, StreamId endId) {
        LinkedList<Object> params = new LinkedList<Object>();
        params.add(this.getName());
        params.add(startId);
        params.add(endId);
        if (count > 0) {
            params.add("COUNT");
            params.add(count);
        }
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.XREVRANGE, params.toArray());
    }

    @Override
    public Map<StreamId, Map<K, V>> rangeReversed(int count, StreamId startId, StreamId endId) {
        return this.get(this.rangeReversedAsync(count, startId, endId));
    }

    @Override
    public RFuture<Map<StreamId, Map<K, V>>> readAsync(StreamId ... ids) {
        return this.readAsync(0, ids);
    }

    @Override
    public RFuture<Map<StreamId, Map<K, V>>> readAsync(long timeout, TimeUnit unit, StreamId ... ids) {
        return this.readAsync(0, timeout, unit, ids);
    }

    @Override
    public RFuture<Map<String, Map<StreamId, Map<K, V>>>> readAsync(Collection<String> keys, StreamId ... ids) {
        return this.readAsync(0, keys, ids);
    }

    @Override
    public RFuture<Map<String, Map<StreamId, Map<K, V>>>> readAsync(long timeout, TimeUnit unit, Collection<String> keys, StreamId ... ids) {
        return this.readAsync(0, timeout, unit, keys, ids);
    }

    @Override
    public RFuture<Map<StreamId, Map<K, V>>> rangeAsync(StreamId startId, StreamId endId) {
        return this.rangeAsync(0, startId, endId);
    }

    @Override
    public RFuture<Map<StreamId, Map<K, V>>> rangeReversedAsync(StreamId startId, StreamId endId) {
        return this.rangeReversedAsync(0, startId, endId);
    }

    @Override
    public Map<StreamId, Map<K, V>> read(StreamId ... ids) {
        return this.read(0, ids);
    }

    @Override
    public Map<StreamId, Map<K, V>> read(long timeout, TimeUnit unit, StreamId ... ids) {
        return this.read(0, timeout, unit, ids);
    }

    @Override
    public Map<String, Map<StreamId, Map<K, V>>> read(Collection<String> keys, StreamId ... ids) {
        return this.read(0, keys, ids);
    }

    @Override
    public Map<String, Map<StreamId, Map<K, V>>> read(long timeout, TimeUnit unit, Collection<String> keys, StreamId ... ids) {
        return this.read(0, timeout, unit, keys, ids);
    }

    @Override
    public Map<StreamId, Map<K, V>> range(StreamId startId, StreamId endId) {
        return this.range(0, startId, endId);
    }

    @Override
    public Map<StreamId, Map<K, V>> rangeReversed(StreamId startId, StreamId endId) {
        return this.rangeReversed(0, startId, endId);
    }
}

