/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBufUtil;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.internal.PlatformDependent;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.PubSubEntry;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonLockEntry;
import org.redisson.api.RFuture;
import org.redisson.api.RPermitExpirableSemaphore;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.redisson.pubsub.SemaphorePubSub;

public class RedissonPermitExpirableSemaphore
extends RedissonExpirable
implements RPermitExpirableSemaphore {
    private final SemaphorePubSub semaphorePubSub;
    final CommandAsyncExecutor commandExecutor;
    private final String timeoutName;
    private final long nonExpirableTimeout = 922337203685477L;

    public RedissonPermitExpirableSemaphore(CommandAsyncExecutor commandExecutor, String name, SemaphorePubSub semaphorePubSub) {
        super(commandExecutor, name);
        this.timeoutName = RedissonPermitExpirableSemaphore.suffixName(name, "timeout");
        this.commandExecutor = commandExecutor;
        this.semaphorePubSub = semaphorePubSub;
    }

    String getChannelName() {
        return RedissonPermitExpirableSemaphore.getChannelName(this.getName());
    }

    public static String getChannelName(String name) {
        if (name.contains("{")) {
            return "redisson_sc:" + name;
        }
        return "redisson_sc:{" + name + "}";
    }

    @Override
    public String acquire() throws InterruptedException {
        return this.acquire(1, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public String acquire(long leaseTime, TimeUnit timeUnit) throws InterruptedException {
        return this.acquire(1, leaseTime, timeUnit);
    }

    @Override
    public RFuture<String> acquireAsync(long leaseTime, TimeUnit timeUnit) {
        return this.acquireAsync(1, leaseTime, timeUnit);
    }

    private String acquire(int permits, long ttl, TimeUnit timeUnit) throws InterruptedException {
        String permitId = this.tryAcquire(permits, ttl, timeUnit);
        if (permitId != null && !permitId.startsWith(":")) {
            return permitId;
        }
        RFuture<RedissonLockEntry> future = this.subscribe();
        this.commandExecutor.syncSubscription(future);
        try {
            while (true) {
                Long nearestTimeout;
                if ((permitId = this.tryAcquire(permits, ttl, timeUnit)) != null) {
                    if (!permitId.startsWith(":")) {
                        String string = permitId;
                        return string;
                    }
                    nearestTimeout = Long.valueOf(permitId.substring(1)) - System.currentTimeMillis();
                } else {
                    nearestTimeout = null;
                }
                if (nearestTimeout != null) {
                    this.getEntry().getLatch().tryAcquire(permits, nearestTimeout, TimeUnit.MILLISECONDS);
                    continue;
                }
                this.getEntry().getLatch().acquire(permits);
            }
        }
        finally {
            this.unsubscribe(future);
        }
    }

    @Override
    public RFuture<String> acquireAsync() {
        return this.acquireAsync(1, -1L, TimeUnit.MILLISECONDS);
    }

    private RFuture<String> acquireAsync(final int permits, final long ttl, final TimeUnit timeUnit) {
        final RedissonPromise<String> result = new RedissonPromise<String>();
        long timeoutDate = this.calcTimeout(ttl, timeUnit);
        RFuture<String> tryAcquireFuture = this.tryAcquireAsync(permits, timeoutDate);
        tryAcquireFuture.addListener(new FutureListener<String>(){

            @Override
            public void operationComplete(Future<String> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                String permitId = future.getNow();
                if (permitId != null && !permitId.startsWith(":")) {
                    if (!result.trySuccess(permitId)) {
                        RedissonPermitExpirableSemaphore.this.releaseAsync(permitId);
                    }
                    return;
                }
                final RFuture subscribeFuture = RedissonPermitExpirableSemaphore.this.subscribe();
                subscribeFuture.addListener(new FutureListener<RedissonLockEntry>(){

                    @Override
                    public void operationComplete(Future<RedissonLockEntry> future) throws Exception {
                        if (!future.isSuccess()) {
                            result.tryFailure(future.cause());
                            return;
                        }
                        RedissonPermitExpirableSemaphore.this.acquireAsync(permits, subscribeFuture, result, ttl, timeUnit);
                    }
                });
            }
        });
        return result;
    }

    private void tryAcquireAsync(final AtomicLong time, final int permits, final RFuture<RedissonLockEntry> subscribeFuture, final RPromise<String> result, final long ttl, final TimeUnit timeUnit) {
        if (result.isDone()) {
            this.unsubscribe(subscribeFuture);
            return;
        }
        if (time.get() <= 0L) {
            this.unsubscribe(subscribeFuture);
            result.trySuccess(null);
            return;
        }
        long timeoutDate = this.calcTimeout(ttl, timeUnit);
        final long current = System.currentTimeMillis();
        RFuture<String> tryAcquireFuture = this.tryAcquireAsync(permits, timeoutDate);
        tryAcquireFuture.addListener(new FutureListener<String>(){

            @Override
            public void operationComplete(Future<String> future) throws Exception {
                Long nearestTimeout;
                if (!future.isSuccess()) {
                    RedissonPermitExpirableSemaphore.this.unsubscribe(subscribeFuture);
                    result.tryFailure(future.cause());
                    return;
                }
                String permitId = future.getNow();
                if (permitId != null) {
                    if (!permitId.startsWith(":")) {
                        RedissonPermitExpirableSemaphore.this.unsubscribe(subscribeFuture);
                        if (!result.trySuccess(permitId)) {
                            RedissonPermitExpirableSemaphore.this.releaseAsync(permitId);
                        }
                        return;
                    }
                    nearestTimeout = Long.valueOf(permitId.substring(1)) - System.currentTimeMillis();
                } else {
                    nearestTimeout = null;
                }
                long elapsed = System.currentTimeMillis() - current;
                time.addAndGet(-elapsed);
                if (time.get() <= 0L) {
                    RedissonPermitExpirableSemaphore.this.unsubscribe(subscribeFuture);
                    result.trySuccess(null);
                    return;
                }
                final long current2 = System.currentTimeMillis();
                final RedissonLockEntry entry = RedissonPermitExpirableSemaphore.this.getEntry();
                if (entry.getLatch().tryAcquire()) {
                    RedissonPermitExpirableSemaphore.this.tryAcquireAsync(time, permits, subscribeFuture, result, ttl, timeUnit);
                } else {
                    final AtomicReference<Timeout> waitTimeoutFutureRef = new AtomicReference<Timeout>();
                    final Timeout scheduledFuture = nearestTimeout != null ? RedissonPermitExpirableSemaphore.this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

                        @Override
                        public void run(Timeout timeout) throws Exception {
                            if (waitTimeoutFutureRef.get() != null && !((Timeout)waitTimeoutFutureRef.get()).cancel()) {
                                return;
                            }
                            long elapsed = System.currentTimeMillis() - current2;
                            time.addAndGet(-elapsed);
                            RedissonPermitExpirableSemaphore.this.tryAcquireAsync(time, permits, subscribeFuture, result, ttl, timeUnit);
                        }
                    }, nearestTimeout, TimeUnit.MILLISECONDS) : null;
                    final Runnable listener = new Runnable(){

                        @Override
                        public void run() {
                            if (waitTimeoutFutureRef.get() != null && !((Timeout)waitTimeoutFutureRef.get()).cancel()) {
                                entry.getLatch().release();
                                return;
                            }
                            if (scheduledFuture != null && !scheduledFuture.cancel()) {
                                entry.getLatch().release();
                                return;
                            }
                            long elapsed = System.currentTimeMillis() - current2;
                            time.addAndGet(-elapsed);
                            RedissonPermitExpirableSemaphore.this.tryAcquireAsync(time, permits, subscribeFuture, result, ttl, timeUnit);
                        }
                    };
                    entry.addListener(listener);
                    long t = time.get();
                    Timeout waitTimeoutFuture = RedissonPermitExpirableSemaphore.this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

                        @Override
                        public void run(Timeout timeout) throws Exception {
                            if (scheduledFuture != null && !scheduledFuture.cancel()) {
                                return;
                            }
                            if (entry.removeListener(listener)) {
                                long elapsed = System.currentTimeMillis() - current2;
                                time.addAndGet(-elapsed);
                                RedissonPermitExpirableSemaphore.this.tryAcquireAsync(time, permits, subscribeFuture, result, ttl, timeUnit);
                            }
                        }
                    }, t, TimeUnit.MILLISECONDS);
                    waitTimeoutFutureRef.set(waitTimeoutFuture);
                }
            }
        });
    }

    private void acquireAsync(final int permits, final RFuture<RedissonLockEntry> subscribeFuture, final RPromise<String> result, final long ttl, final TimeUnit timeUnit) {
        if (result.isDone()) {
            this.unsubscribe(subscribeFuture);
            return;
        }
        long timeoutDate = this.calcTimeout(ttl, timeUnit);
        RFuture<String> tryAcquireFuture = this.tryAcquireAsync(permits, timeoutDate);
        tryAcquireFuture.addListener(new FutureListener<String>(){

            @Override
            public void operationComplete(Future<String> future) throws Exception {
                Long nearestTimeout;
                if (!future.isSuccess()) {
                    RedissonPermitExpirableSemaphore.this.unsubscribe(subscribeFuture);
                    result.tryFailure(future.cause());
                    return;
                }
                String permitId = future.getNow();
                if (permitId != null) {
                    if (!permitId.startsWith(":")) {
                        RedissonPermitExpirableSemaphore.this.unsubscribe(subscribeFuture);
                        if (!result.trySuccess(permitId)) {
                            RedissonPermitExpirableSemaphore.this.releaseAsync(permitId);
                        }
                        return;
                    }
                    nearestTimeout = Long.valueOf(permitId.substring(1)) - System.currentTimeMillis();
                } else {
                    nearestTimeout = null;
                }
                final RedissonLockEntry entry = RedissonPermitExpirableSemaphore.this.getEntry();
                if (entry.getLatch().tryAcquire(permits)) {
                    RedissonPermitExpirableSemaphore.this.acquireAsync(permits, subscribeFuture, result, ttl, timeUnit);
                } else {
                    final Timeout scheduledFuture = nearestTimeout != null ? RedissonPermitExpirableSemaphore.this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

                        @Override
                        public void run(Timeout timeout) throws Exception {
                            RedissonPermitExpirableSemaphore.this.acquireAsync(permits, subscribeFuture, result, ttl, timeUnit);
                        }
                    }, nearestTimeout, TimeUnit.MILLISECONDS) : null;
                    Runnable listener = new Runnable(){

                        @Override
                        public void run() {
                            if (scheduledFuture != null && !scheduledFuture.cancel()) {
                                entry.getLatch().release();
                                return;
                            }
                            RedissonPermitExpirableSemaphore.this.acquireAsync(permits, subscribeFuture, result, ttl, timeUnit);
                        }
                    };
                    entry.addListener(listener);
                }
            }
        });
    }

    @Override
    public String tryAcquire() {
        String res = this.tryAcquire(1, -1L, TimeUnit.MILLISECONDS);
        if (res != null && res.startsWith(":")) {
            return null;
        }
        return res;
    }

    private String tryAcquire(int permits, long ttl, TimeUnit timeUnit) {
        long timeoutDate = this.calcTimeout(ttl, timeUnit);
        return this.get(this.tryAcquireAsync(permits, timeoutDate));
    }

    private long calcTimeout(long ttl, TimeUnit timeUnit) {
        if (ttl != -1L) {
            return System.currentTimeMillis() + timeUnit.toMillis(ttl);
        }
        return 922337203685477L;
    }

    @Override
    public RFuture<String> tryAcquireAsync() {
        final RedissonPromise<String> result = new RedissonPromise<String>();
        RFuture<String> res = this.tryAcquireAsync(1, 922337203685477L);
        res.addListener(new FutureListener<String>(){

            @Override
            public void operationComplete(Future<String> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                String permitId = future.getNow();
                if (permitId != null && !permitId.startsWith(":")) {
                    if (!result.trySuccess(permitId)) {
                        RedissonPermitExpirableSemaphore.this.releaseAsync(permitId);
                    }
                } else {
                    result.trySuccess(null);
                }
            }
        });
        return result;
    }

    protected String generateId() {
        byte[] id = new byte[16];
        PlatformDependent.threadLocalRandom().nextBytes(id);
        return ByteBufUtil.hexDump(id);
    }

    public RFuture<String> tryAcquireAsync(int permits, long timeoutDate) {
        if (permits < 0) {
            throw new IllegalArgumentException("Permits amount can't be negative");
        }
        String id = this.generateId();
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_STRING_DATA, "local expiredIds = redis.call('zrangebyscore', KEYS[2], 0, ARGV[4], 'limit', 0, ARGV[1]); if #expiredIds > 0 then redis.call('zrem', KEYS[2], unpack(expiredIds)); local value = redis.call('incrby', KEYS[1], #expiredIds); if tonumber(value) > 0 then redis.call('publish', KEYS[3], value); end;end; local value = redis.call('get', KEYS[1]); if (value ~= false and tonumber(value) >= tonumber(ARGV[1])) then redis.call('decrby', KEYS[1], ARGV[1]); redis.call('zadd', KEYS[2], ARGV[2], ARGV[3]); return ARGV[3]; end; local v = redis.call('zrange', KEYS[2], 0, 0, 'WITHSCORES'); if v[1] ~= nil and v[2] ~= ARGV[5] then return ':' .. tostring(v[2]); end return nil;", Arrays.asList(this.getName(), this.timeoutName, this.getChannelName()), permits, timeoutDate, id, System.currentTimeMillis(), 922337203685477L);
    }

    @Override
    public RFuture<String> tryAcquireAsync(long waitTime, TimeUnit unit) {
        return this.tryAcquireAsync(1, waitTime, -1L, unit);
    }

    @Override
    public String tryAcquire(long waitTime, long ttl, TimeUnit unit) throws InterruptedException {
        return this.tryAcquire(1, waitTime, ttl, unit);
    }

    @Override
    public RFuture<String> tryAcquireAsync(long waitTime, long ttl, TimeUnit unit) {
        return this.tryAcquireAsync(1, waitTime, ttl, unit);
    }

    private String tryAcquire(int permits, long waitTime, long ttl, TimeUnit unit) throws InterruptedException {
        long time = unit.toMillis(waitTime);
        long current = System.currentTimeMillis();
        String permitId = this.tryAcquire(permits, ttl, unit);
        if (permitId != null && !permitId.startsWith(":")) {
            return permitId;
        }
        if ((time -= System.currentTimeMillis() - current) <= 0L) {
            return null;
        }
        current = System.currentTimeMillis();
        RFuture<RedissonLockEntry> future = this.subscribe();
        if (!this.await(future, time, TimeUnit.MILLISECONDS)) {
            return null;
        }
        try {
            if ((time -= System.currentTimeMillis() - current) <= 0L) {
                String string = null;
                return string;
            }
            while (true) {
                Long nearestTimeout;
                current = System.currentTimeMillis();
                permitId = this.tryAcquire(permits, ttl, unit);
                if (permitId != null) {
                    if (!permitId.startsWith(":")) {
                        String string = permitId;
                        return string;
                    }
                    nearestTimeout = Long.valueOf(permitId.substring(1)) - System.currentTimeMillis();
                } else {
                    nearestTimeout = null;
                }
                if ((time -= System.currentTimeMillis() - current) <= 0L) {
                    String string = null;
                    return string;
                }
                current = System.currentTimeMillis();
                if (nearestTimeout != null) {
                    this.getEntry().getLatch().tryAcquire(permits, Math.min(time, nearestTimeout), TimeUnit.MILLISECONDS);
                } else {
                    this.getEntry().getLatch().tryAcquire(permits, time, TimeUnit.MILLISECONDS);
                }
                long elapsed = System.currentTimeMillis() - current;
                if ((time -= elapsed) > 0L) continue;
                String string = null;
                return string;
            }
        }
        finally {
            this.unsubscribe(future);
        }
    }

    private RFuture<String> tryAcquireAsync(final int permits, long waitTime, final long ttl, final TimeUnit timeUnit) {
        final RedissonPromise<String> result = new RedissonPromise<String>();
        final AtomicLong time = new AtomicLong(timeUnit.toMillis(waitTime));
        final long current = System.currentTimeMillis();
        long timeoutDate = this.calcTimeout(ttl, timeUnit);
        RFuture<String> tryAcquireFuture = this.tryAcquireAsync(permits, timeoutDate);
        tryAcquireFuture.addListener(new FutureListener<String>(){

            @Override
            public void operationComplete(Future<String> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                String permitId = future.getNow();
                if (permitId != null && !permitId.startsWith(":")) {
                    if (!result.trySuccess(permitId)) {
                        RedissonPermitExpirableSemaphore.this.releaseAsync(permitId);
                    }
                    return;
                }
                long elapsed = System.currentTimeMillis() - current;
                time.addAndGet(-elapsed);
                if (time.get() <= 0L) {
                    result.trySuccess(null);
                    return;
                }
                final long current2 = System.currentTimeMillis();
                final AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
                final RFuture subscribeFuture = RedissonPermitExpirableSemaphore.this.subscribe();
                subscribeFuture.addListener(new FutureListener<RedissonLockEntry>(){

                    @Override
                    public void operationComplete(Future<RedissonLockEntry> future) throws Exception {
                        if (!future.isSuccess()) {
                            result.tryFailure(future.cause());
                            return;
                        }
                        if (futureRef.get() != null) {
                            ((Timeout)futureRef.get()).cancel();
                        }
                        long elapsed = System.currentTimeMillis() - current2;
                        time.addAndGet(-elapsed);
                        RedissonPermitExpirableSemaphore.this.tryAcquireAsync(time, permits, subscribeFuture, result, ttl, timeUnit);
                    }
                });
                if (!subscribeFuture.isDone()) {
                    Timeout scheduledFuture = RedissonPermitExpirableSemaphore.this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

                        @Override
                        public void run(Timeout timeout) throws Exception {
                            if (!subscribeFuture.isDone()) {
                                result.trySuccess(null);
                            }
                        }
                    }, time.get(), TimeUnit.MILLISECONDS);
                    futureRef.set(scheduledFuture);
                }
            }
        });
        return result;
    }

    private RedissonLockEntry getEntry() {
        return (RedissonLockEntry)this.semaphorePubSub.getEntry(this.getName());
    }

    private RFuture<RedissonLockEntry> subscribe() {
        return this.semaphorePubSub.subscribe(this.getName(), this.getChannelName(), this.commandExecutor.getConnectionManager().getSubscribeService());
    }

    private void unsubscribe(RFuture<RedissonLockEntry> future) {
        this.semaphorePubSub.unsubscribe((PubSubEntry)future.getNow(), this.getName(), this.getChannelName(), this.commandExecutor.getConnectionManager().getSubscribeService());
    }

    @Override
    public String tryAcquire(long waitTime, TimeUnit unit) throws InterruptedException {
        String res = this.tryAcquire(1, waitTime, -1L, unit);
        if (res != null && res.startsWith(":")) {
            return null;
        }
        return res;
    }

    @Override
    public void release(String permitId) {
        this.get(this.releaseAsync(permitId));
    }

    @Override
    public boolean tryRelease(String permitId) {
        return this.get(this.tryReleaseAsync(permitId));
    }

    @Override
    public RFuture<Boolean> tryReleaseAsync(String permitId) {
        if (permitId == null) {
            throw new IllegalArgumentException("permitId can't be null");
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local removed = redis.call('zrem', KEYS[3], ARGV[1]);if tonumber(removed) ~= 1 then return 0;end;local value = redis.call('incrby', KEYS[1], ARGV[2]); redis.call('publish', KEYS[2], value); return 1;", Arrays.asList(this.getName(), this.getChannelName(), this.timeoutName), permitId, 1);
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.DEL_OBJECTS, this.getName(), this.timeoutName);
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "redis.call('pexpire', KEYS[1], ARGV[1]); return redis.call('pexpire', KEYS[2], ARGV[1]); ", Arrays.asList(this.getName(), this.timeoutName), timeUnit.toMillis(timeToLive));
    }

    @Override
    public RFuture<Boolean> expireAtAsync(long timestamp) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "redis.call('pexpireat', KEYS[1], ARGV[1]); return redis.call('pexpireat', KEYS[2], ARGV[1]); ", Arrays.asList(this.getName(), this.timeoutName), timestamp);
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "redis.call('persist', KEYS[1]); return redis.call('persist', KEYS[2]); ", Arrays.asList(this.getName(), this.timeoutName), new Object[0]);
    }

    @Override
    public RFuture<Void> releaseAsync(final String permitId) {
        final RedissonPromise<Void> result = new RedissonPromise<Void>();
        this.tryReleaseAsync(permitId).addListener(new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                if (future.getNow().booleanValue()) {
                    result.trySuccess(null);
                } else {
                    result.tryFailure(new IllegalArgumentException("Permit with id " + permitId + " has already been released or doesn't exist"));
                }
            }
        });
        return result;
    }

    @Override
    public int availablePermits() {
        return this.get(this.availablePermitsAsync());
    }

    @Override
    public RFuture<Integer> availablePermitsAsync() {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local expiredIds = redis.call('zrangebyscore', KEYS[2], 0, ARGV[1], 'limit', 0, -1); if #expiredIds > 0 then redis.call('zrem', KEYS[2], unpack(expiredIds)); local value = redis.call('incrby', KEYS[1], #expiredIds); if tonumber(value) > 0 then redis.call('publish', KEYS[3], value); end;return value; end; local ret = redis.call('get', KEYS[1]); return ret == false and 0 or ret;", Arrays.asList(this.getName(), this.timeoutName, this.getChannelName()), System.currentTimeMillis());
    }

    @Override
    public boolean trySetPermits(int permits) {
        return this.get(this.trySetPermitsAsync(permits));
    }

    @Override
    public RFuture<Boolean> trySetPermitsAsync(int permits) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('get', KEYS[1]); if (value == false or value == 0) then redis.call('set', KEYS[1], ARGV[1]); redis.call('publish', KEYS[2], ARGV[1]); return 1;end;return 0;", Arrays.asList(this.getName(), this.getChannelName()), permits);
    }

    @Override
    public void addPermits(int permits) {
        this.get(this.addPermitsAsync(permits));
    }

    @Override
    public RFuture<Void> addPermitsAsync(int permits) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_VOID, "local value = redis.call('get', KEYS[1]); if (value == false) then value = 0;end;redis.call('set', KEYS[1], tonumber(value) + tonumber(ARGV[1])); if tonumber(ARGV[1]) > 0 then redis.call('publish', KEYS[2], ARGV[1]); end;", Arrays.asList(this.getName(), this.getChannelName()), permits);
    }
}

