/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.concurrent.atomic.DoubleAdder;
import org.redisson.RedissonBaseAdder;
import org.redisson.api.RAtomicDouble;
import org.redisson.api.RDoubleAdder;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonClient;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonDoubleAdder
extends RedissonBaseAdder<Double>
implements RDoubleAdder {
    private final DoubleAdder counter = new DoubleAdder();
    private final RAtomicDouble atomicDouble;

    public RedissonDoubleAdder(CommandAsyncExecutor connectionManager, String name, RedissonClient redisson) {
        super(connectionManager, name, redisson);
        this.atomicDouble = redisson.getAtomicDouble(this.getName());
    }

    @Override
    protected void doReset() {
        this.counter.reset();
    }

    @Override
    protected RFuture<Double> addAndGetAsync() {
        return this.atomicDouble.getAndAddAsync(this.counter.sum());
    }

    @Override
    protected RFuture<Double> getAndDeleteAsync() {
        return this.atomicDouble.getAndDeleteAsync();
    }

    @Override
    public void add(double x) {
        this.counter.add(x);
    }

    @Override
    public void increment() {
        this.add(1.0);
    }

    @Override
    public void decrement() {
        this.add(-1.0);
    }

    @Override
    public double sum() {
        return (Double)this.get(this.sumAsync());
    }
}

