/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxIterable;
import reactor.core.publisher.Operators;

final class FluxStream<T>
extends Flux<T>
implements Fuseable {
    final Stream<? extends T> stream;

    FluxStream(Stream<? extends T> iterable) {
        this.stream = Objects.requireNonNull(iterable, "stream");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Iterator it;
        try {
            it = Objects.requireNonNull(this.stream.iterator(), "The stream returned a null Iterator");
        }
        catch (Throwable e) {
            Operators.error(actual, Operators.onOperatorError(e, actual.currentContext()));
            return;
        }
        FluxIterable.subscribe(actual, it);
    }
}

