/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.stream;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.support.Exceptions;
import reactor.rx.Stream;
import reactor.rx.subscription.ReactiveSubscription;

public class PublisherStream<T>
extends Stream<T> {
    private final Publisher<T> source;

    public PublisherStream(Publisher<T> publisher) {
        this.source = publisher;
    }

    @Override
    public void subscribe(Subscriber<? super T> subscriber) {
        try {
            subscriber.onSubscribe(new ReactiveSubscription<T>(this, subscriber){
                private boolean started;
                private ReactiveSubscription<T> thiz;
                private Subscription subscription;
                {
                    this.started = false;
                    this.thiz = this;
                }

                @Override
                protected void onRequest(long elements) {
                    super.onRequest(elements);
                    if (!this.started) {
                        this.started = true;
                        PublisherStream.this.source.subscribe(new Subscriber<T>(){

                            @Override
                            public void onSubscribe(Subscription s) {
                                subscription = s;
                            }

                            @Override
                            public void onNext(T t) {
                                thiz.onNext(t);
                            }

                            @Override
                            public void onError(Throwable t) {
                                thiz.onError(t);
                            }

                            @Override
                            public void onComplete() {
                                thiz.onComplete();
                            }
                        });
                    } else if (this.subscription != null) {
                        this.subscription.request(elements);
                    }
                }

                @Override
                public void cancel() {
                    super.cancel();
                    if (this.subscription != null) {
                        this.subscription.cancel();
                    }
                }
            });
        }
        catch (Throwable throwable) {
            Exceptions.throwIfFatal(throwable);
            subscriber.onError(throwable);
        }
    }
}

