/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol.decoder;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.redisson.api.StreamInfo;
import org.redisson.api.StreamMessageId;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.convertor.StreamIdConvertor;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class StreamInfoDecoder
implements MultiDecoder<StreamInfo<Object, Object>> {
    private static final String LENGTH_KEY = "length";
    private static final String RADIX_TREE_KEYS_KEY = "radix-tree-keys";
    private static final String RADIX_TREE_NODES_KEY = "radix-tree-nodes";
    private static final String GROUPS_KEY = "groups";
    private static final String LAST_GENERATED_ID_KEY = "last-generated-id";
    private static final String FIRST_ENTRY_KEY = "first-entry";
    private static final String LAST_ENTRY_KEY = "last-entry";
    private static final String MAX_DELETED_ENTRY_ID = "max-deleted-entry-id";
    private static final String ENTRIES_ADDED = "entries-added";
    private static final String RECORDED_FIRST_ENTRY_ID = "recorded-first-entry-id";

    @Override
    public StreamInfo<Object, Object> decode(List<Object> parts, State state) {
        List lastEntry;
        Map<String, Object> map = IntStream.range(0, parts.size()).filter(i -> i % 2 == 0).mapToObj(i -> parts.subList(i, i + 2)).filter(p -> p.get(1) != null).collect(Collectors.toMap(e -> (String)e.get(0), e -> e.get(1)));
        StreamInfo<Object, Object> info = new StreamInfo<Object, Object>();
        info.setLength(((Long)map.get(LENGTH_KEY)).intValue());
        info.setRadixTreeKeys(((Long)map.get(RADIX_TREE_KEYS_KEY)).intValue());
        info.setRadixTreeNodes(((Long)map.get(RADIX_TREE_NODES_KEY)).intValue());
        info.setGroups(((Long)map.get(GROUPS_KEY)).intValue());
        info.setLastGeneratedId(StreamIdConvertor.INSTANCE.convert(map.get(LAST_GENERATED_ID_KEY)));
        info.setMaxDeletedEntryId(StreamIdConvertor.INSTANCE.convert(map.getOrDefault(MAX_DELETED_ENTRY_ID, "0-0")));
        info.setRecordedFirstEntryId(StreamIdConvertor.INSTANCE.convert(map.getOrDefault(RECORDED_FIRST_ENTRY_ID, "0-0")));
        info.setEntriesAdded(((Long)map.getOrDefault(ENTRIES_ADDED, -1L)).intValue());
        List firstEntry = (List)map.get(FIRST_ENTRY_KEY);
        if (firstEntry != null) {
            StreamInfo.Entry<Object, Object> first = this.createStreamInfoEntry(firstEntry);
            info.setFirstEntry(first);
        }
        if ((lastEntry = (List)map.get(LAST_ENTRY_KEY)) != null) {
            StreamInfo.Entry<Object, Object> last = this.createStreamInfoEntry(lastEntry);
            info.setLastEntry(last);
        }
        return info;
    }

    private StreamInfo.Entry<Object, Object> createStreamInfoEntry(List<?> fieldValue) {
        StreamMessageId id = StreamIdConvertor.INSTANCE.convert(fieldValue.get(0));
        Map data = (Map)fieldValue.get(1);
        return new StreamInfo.Entry<Object, Object>(id, data);
    }
}

