/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import org.redisson.PubSubEntry;

public class RedissonLockEntry
implements PubSubEntry<RedissonLockEntry> {
    private volatile int counter;
    private final Semaphore latch;
    private final CompletableFuture<RedissonLockEntry> promise;
    private final ConcurrentLinkedQueue<Runnable> listeners = new ConcurrentLinkedQueue();

    public RedissonLockEntry(CompletableFuture<RedissonLockEntry> promise) {
        this.latch = new Semaphore(0);
        this.promise = promise;
    }

    public int acquired() {
        return this.counter;
    }

    @Override
    public void acquire() {
        ++this.counter;
    }

    @Override
    public int release() {
        return --this.counter;
    }

    @Override
    public CompletableFuture<RedissonLockEntry> getPromise() {
        return this.promise;
    }

    public void addListener(Runnable listener) {
        this.listeners.add(listener);
        if (this.latch.tryAcquire()) {
            this.tryRunListener();
        }
    }

    public void tryRunListener() {
        Runnable runnableToExecute = this.listeners.poll();
        if (runnableToExecute != null) {
            runnableToExecute.run();
        }
    }

    public void tryRunAllListeners() {
        Runnable runnableToExecute;
        while ((runnableToExecute = this.listeners.poll()) != null) {
            runnableToExecute.run();
        }
    }

    public boolean removeListener(Runnable listener) {
        return this.listeners.remove(listener);
    }

    public Semaphore getLatch() {
        return this.latch;
    }

    public String toString() {
        return "RedissonLockEntry{counter=" + this.counter + '}';
    }
}

