/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.queue;

import java.util.AbstractQueue;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.core.queue.CompletableQueue;
import reactor.io.queue.InMemoryQueuePersistor;
import reactor.io.queue.QueuePersistor;

public class PersistentQueue<T>
extends AbstractQueue<T>
implements CompletableQueue<T> {
    private final QueuePersistor<T> persistor;
    boolean terminated = false;

    public PersistentQueue(@Nullable QueuePersistor<T> persistor) {
        this.persistor = null == persistor ? new InMemoryQueuePersistor() : persistor;
    }

    public void close() {
        this.persistor.close();
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return this.persistor.iterator();
    }

    @Override
    public int size() {
        return (int)this.persistor.size();
    }

    @Override
    public boolean offer(T obj) {
        return null != this.persistor.offer(obj);
    }

    @Override
    public T poll() {
        if (this.size() == 0 || !this.persistor.hasNext()) {
            return null;
        }
        return this.persistor.remove();
    }

    @Override
    public T peek() {
        if (this.size() == 0 || !this.persistor.hasNext()) {
            return null;
        }
        Long lastId = this.persistor.lastId();
        return this.persistor.get(lastId);
    }

    @Override
    public void complete() {
        this.terminated = true;
    }

    @Override
    public boolean isComplete() {
        return this.terminated;
    }
}

