/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.Collections;
import java.util.List;
import org.reactivestreams.Publisher;
import org.redisson.PubSubMessageListener;
import org.redisson.PubSubStatusListener;
import org.redisson.api.RFuture;
import org.redisson.api.RTopicReactive;
import org.redisson.api.listener.MessageListener;
import org.redisson.api.listener.StatusListener;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.connection.PubSubConnectionEntry;
import org.redisson.misc.RPromise;
import org.redisson.pubsub.AsyncSemaphore;
import org.redisson.reactive.NettyFuturePublisher;
import reactor.fn.Supplier;

public class RedissonTopicReactive<M>
implements RTopicReactive<M> {
    private final CommandReactiveExecutor commandExecutor;
    private final String name;
    private final Codec codec;

    public RedissonTopicReactive(CommandReactiveExecutor commandExecutor, String name) {
        this(commandExecutor.getConnectionManager().getCodec(), commandExecutor, name);
    }

    public RedissonTopicReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        this.commandExecutor = commandExecutor;
        this.name = name;
        this.codec = codec;
    }

    @Override
    public List<String> getChannelNames() {
        return Collections.singletonList(this.name);
    }

    @Override
    public Publisher<Long> publish(M message) {
        return this.commandExecutor.writeReactive(this.name, this.codec, RedisCommands.PUBLISH, this.name, message);
    }

    @Override
    public Publisher<Integer> addListener(StatusListener listener) {
        return this.addListener(new PubSubStatusListener(listener, this.name));
    }

    @Override
    public Publisher<Integer> addListener(MessageListener<M> listener) {
        PubSubMessageListener<M> pubSubListener = new PubSubMessageListener<M>(listener, this.name);
        return this.addListener((RedisPubSubListener<?>)pubSubListener);
    }

    @Override
    private Publisher<Integer> addListener(final RedisPubSubListener<?> pubSubListener) {
        return new NettyFuturePublisher<Integer>(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                final RPromise<Integer> promise = RedissonTopicReactive.this.commandExecutor.getConnectionManager().newPromise();
                RFuture<PubSubConnectionEntry> future = RedissonTopicReactive.this.commandExecutor.getConnectionManager().subscribe(RedissonTopicReactive.this.codec, RedissonTopicReactive.this.name, pubSubListener);
                future.addListener(new FutureListener<PubSubConnectionEntry>(){

                    @Override
                    public void operationComplete(Future<PubSubConnectionEntry> future) throws Exception {
                        if (!future.isSuccess()) {
                            promise.tryFailure(future.cause());
                            return;
                        }
                        promise.trySuccess(System.identityHashCode(pubSubListener));
                    }
                });
                return promise;
            }
        });
    }

    @Override
    public void removeListener(int listenerId) {
        AsyncSemaphore semaphore = this.commandExecutor.getConnectionManager().getSemaphore(this.name);
        semaphore.acquireUninterruptibly();
        PubSubConnectionEntry entry = this.commandExecutor.getConnectionManager().getPubSubEntry(this.name);
        if (entry == null) {
            semaphore.release();
            return;
        }
        entry.removeListener(this.name, listenerId);
        if (!entry.hasListeners(this.name)) {
            this.commandExecutor.getConnectionManager().unsubscribe(this.name, semaphore);
        } else {
            semaphore.release();
        }
    }
}

