/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.jcache.configuration;

import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;

public class RedissonConfiguration<K, V>
implements Configuration<K, V> {
    private static final long serialVersionUID = 5331107577281201157L;
    private Configuration<K, V> jcacheConfig;
    private Config config;
    private RedissonClient redisson;

    RedissonConfiguration(Config config, Configuration<K, V> jcacheConfig) {
        this.config = config;
        this.jcacheConfig = jcacheConfig;
    }

    RedissonConfiguration(RedissonClient redisson, Configuration<K, V> jcacheConfig) {
        this.redisson = redisson;
        this.jcacheConfig = jcacheConfig;
    }

    public static <K, V> Configuration<K, V> fromInstance(RedissonClient redisson) {
        MutableConfiguration config = new MutableConfiguration();
        return RedissonConfiguration.fromInstance(redisson, config);
    }

    public static <K, V> Configuration<K, V> fromInstance(RedissonClient redisson, Configuration<K, V> jcacheConfig) {
        return new RedissonConfiguration<K, V>(redisson, jcacheConfig);
    }

    public static <K, V> Configuration<K, V> fromConfig(Config config) {
        MutableConfiguration jcacheConfig = new MutableConfiguration();
        return new RedissonConfiguration(config, jcacheConfig);
    }

    public static <K, V> Configuration<K, V> fromConfig(Config config, Configuration<K, V> jcacheConfig) {
        return new RedissonConfiguration<K, V>(config, jcacheConfig);
    }

    public Configuration<K, V> getJcacheConfig() {
        return this.jcacheConfig;
    }

    public RedissonClient getRedisson() {
        return this.redisson;
    }

    public Config getConfig() {
        return this.config;
    }

    @Override
    public Class<K> getKeyType() {
        return Object.class;
    }

    @Override
    public Class<V> getValueType() {
        return Object.class;
    }

    @Override
    public boolean isStoreByValue() {
        return true;
    }
}

