/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonList;
import org.redisson.api.RFuture;
import org.redisson.api.RQueue;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonQueue<V>
extends RedissonList<V>
implements RQueue<V> {
    protected RedissonQueue(CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(commandExecutor, name, redisson);
    }

    protected RedissonQueue(Codec codec, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(codec, commandExecutor, name, redisson);
    }

    @Override
    public boolean offer(V e) {
        return this.get(this.offerAsync(e));
    }

    @Override
    public RFuture<Boolean> offerAsync(V e) {
        return this.addAsync(e);
    }

    @Override
    public V getFirst() {
        Object value = this.getValue(0);
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    @Override
    public V removeFirst() {
        V value = this.poll();
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    protected long toSeconds(long timeout, TimeUnit unit) {
        long seconds = unit.toSeconds(timeout);
        if (timeout != 0L && seconds == 0L) {
            seconds = 1L;
        }
        return seconds;
    }

    @Override
    public V remove() {
        return this.removeFirst();
    }

    @Override
    public RFuture<V> pollAsync() {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.LPOP, this.getName());
    }

    @Override
    public V poll() {
        return this.get(this.pollAsync());
    }

    @Override
    public V element() {
        return this.getFirst();
    }

    @Override
    public RFuture<V> peekAsync() {
        return this.getAsync(0);
    }

    @Override
    public V peek() {
        return this.getValue(0);
    }

    @Override
    public V pollLastAndOfferFirstTo(String queueName) {
        return this.get(this.pollLastAndOfferFirstToAsync(queueName));
    }

    @Override
    public RFuture<V> pollLastAndOfferFirstToAsync(String queueName) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.RPOPLPUSH, this.getName(), queueName);
    }
}

