/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.math.BigDecimal;
import java.util.Collections;
import org.redisson.RedissonExpirable;
import org.redisson.api.RAtomicDouble;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.DoubleCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.client.protocol.convertor.SingleConvertor;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonAtomicDouble
extends RedissonExpirable
implements RAtomicDouble {
    protected RedissonAtomicDouble(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    @Override
    public double addAndGet(double delta) {
        return this.get(this.addAndGetAsync(delta));
    }

    @Override
    public RFuture<Double> addAndGetAsync(double delta) {
        if (delta == 0.0) {
            return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.INCRBYFLOAT, this.getName(), 0);
        }
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.INCRBYFLOAT, this.getName(), BigDecimal.valueOf(delta).toPlainString());
    }

    @Override
    public boolean compareAndSet(double expect, double update) {
        return this.get(this.compareAndSetAsync(expect, update));
    }

    @Override
    public RFuture<Boolean> compareAndSetAsync(double expect, double update) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if tonumber(redis.call('get', KEYS[1])) == tonumber(ARGV[1]) then redis.call('set', KEYS[1], ARGV[2]); return 1 else return 0 end", Collections.singletonList(this.getName()), BigDecimal.valueOf(expect).toPlainString(), BigDecimal.valueOf(update).toPlainString());
    }

    @Override
    public double decrementAndGet() {
        return this.get(this.decrementAndGetAsync());
    }

    @Override
    public RFuture<Double> decrementAndGetAsync() {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.DECR, this.getName());
    }

    @Override
    public double get() {
        return this.addAndGet(0.0);
    }

    @Override
    public RFuture<Double> getAsync() {
        return this.addAndGetAsync(0.0);
    }

    @Override
    public double getAndAdd(double delta) {
        return this.get(this.getAndAddAsync(delta));
    }

    @Override
    public RFuture<Double> getAndAddAsync(final double delta) {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, new RedisStrictCommand<Double>("INCRBYFLOAT", (Convertor<Double>)new SingleConvertor<Double>(){

            @Override
            public Double convert(Object obj) {
                return Double.valueOf(obj.toString()) - delta;
            }
        }), this.getName(), BigDecimal.valueOf(delta).toPlainString());
    }

    @Override
    public double getAndSet(double newValue) {
        return this.get(this.getAndSetAsync(newValue));
    }

    @Override
    public RFuture<Double> getAndSetAsync(double newValue) {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)DoubleCodec.INSTANCE, RedisCommands.GETSET, this.getName(), BigDecimal.valueOf(newValue).toPlainString());
    }

    @Override
    public double incrementAndGet() {
        return this.get(this.incrementAndGetAsync());
    }

    @Override
    public RFuture<Double> incrementAndGetAsync() {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.INCRBYFLOAT, this.getName(), 1);
    }

    @Override
    public double getAndIncrement() {
        return this.getAndAdd(1.0);
    }

    @Override
    public RFuture<Double> getAndIncrementAsync() {
        return this.getAndAddAsync(1.0);
    }

    @Override
    public double getAndDecrement() {
        return this.getAndAdd(-1.0);
    }

    @Override
    public RFuture<Double> getAndDecrementAsync() {
        return this.getAndAddAsync(-1.0);
    }

    @Override
    public void set(double newValue) {
        this.get(this.setAsync(newValue));
    }

    @Override
    public RFuture<Void> setAsync(double newValue) {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.SET, this.getName(), BigDecimal.valueOf(newValue));
    }

    public String toString() {
        return Double.toString(this.get());
    }
}

