/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.command;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.internal.PlatformDependent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.RedissonReference;
import org.redisson.RedissonShutdownException;
import org.redisson.api.RFuture;
import org.redisson.client.RedisAskException;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisLoadingException;
import org.redisson.client.RedisMovedException;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.RedisTryAgainException;
import org.redisson.client.WriteRedisConnectionException;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.BatchCommandData;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.CommandsData;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.AsyncDetails;
import org.redisson.command.CommandReactiveService;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.NodeSource;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonObjectFactory;

public class CommandBatchService
extends CommandReactiveService {
    private final AtomicInteger index = new AtomicInteger();
    private ConcurrentMap<MasterSlaveEntry, Entry> commands = PlatformDependent.newConcurrentHashMap();
    private volatile boolean executed;

    public CommandBatchService(ConnectionManager connectionManager) {
        super(connectionManager);
    }

    @Override
    protected <V, R> void async(boolean readOnlyMode, NodeSource nodeSource, Codec codec, RedisCommand<V> command, Object[] params, RPromise<R> mainPromise, int attempt) {
        if (this.executed) {
            throw new IllegalStateException("Batch already has been executed!");
        }
        Entry entry = (Entry)this.commands.get(nodeSource.getEntry());
        if (entry == null) {
            entry = new Entry();
            Entry oldEntry = this.commands.putIfAbsent(nodeSource.getEntry(), entry);
            if (oldEntry != null) {
                entry = oldEntry;
            }
        }
        if (!readOnlyMode) {
            entry.setReadOnlyMode(false);
        }
        if (this.isRedissonReferenceSupportEnabled()) {
            for (int i = 0; i < params.length; ++i) {
                RedissonReference reference = RedissonObjectFactory.toReference(this.connectionManager.getCfg(), params[i]);
                if (reference == null) continue;
                params[i] = reference;
            }
        }
        BatchCommandData<V, R> commandData = new BatchCommandData<V, R>(mainPromise, codec, command, params, this.index.incrementAndGet());
        entry.getCommands().add(commandData);
    }

    public List<?> execute() {
        return this.get(this.executeAsync(0L, 0, 0L));
    }

    public List<?> execute(long responseTimeout, int retryAttempts, long retryInterval) {
        return this.get(this.executeAsync(responseTimeout, retryAttempts, retryInterval));
    }

    public RFuture<Void> executeAsyncVoid() {
        return this.executeAsyncVoid(false, 0L, 0, 0L);
    }

    private RFuture<Void> executeAsyncVoid(boolean noResult, long responseTimeout, int retryAttempts, long retryInterval) {
        if (this.executed) {
            throw new IllegalStateException("Batch already executed!");
        }
        if (this.commands.isEmpty()) {
            return this.connectionManager.newSucceededFuture(null);
        }
        if (noResult) {
            for (Entry entry : this.commands.values()) {
                RPromise s = this.connectionManager.newPromise();
                BatchCommandData offCommand = new BatchCommandData(s, null, RedisCommands.CLIENT_REPLY, new Object[]{"OFF"}, this.index.incrementAndGet());
                entry.getCommands().addFirst(offCommand);
                RPromise s1 = this.connectionManager.newPromise();
                BatchCommandData onCommand = new BatchCommandData(s1, null, RedisCommands.CLIENT_REPLY, new Object[]{"ON"}, this.index.incrementAndGet());
                entry.getCommands().add(onCommand);
            }
        }
        this.executed = true;
        RPromise<Void> voidPromise = this.connectionManager.newPromise();
        voidPromise.addListener((FutureListener)new FutureListener<Void>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                CommandBatchService.this.commands = null;
            }
        });
        AtomicInteger slots = new AtomicInteger(this.commands.size());
        for (Map.Entry e : this.commands.entrySet()) {
            this.execute((Entry)e.getValue(), new NodeSource((MasterSlaveEntry)e.getKey()), voidPromise, slots, 0, true, responseTimeout, retryAttempts, retryInterval);
        }
        return voidPromise;
    }

    public void executeSkipResult(long timeout, int retryAttempts, long retryInterval) {
        this.get(this.executeSkipResultAsync(timeout, retryAttempts, retryInterval));
    }

    public RFuture<Void> executeSkipResultAsync(long timeout, int retryAttempts, long retryInterval) {
        return this.executeAsyncVoid(true, timeout, retryAttempts, retryInterval);
    }

    public RFuture<List<?>> executeAsync() {
        return this.executeAsync(0L, 0, 0L);
    }

    public RFuture<List<?>> executeAsync(long responseTimeout, int retryAttempts, long retryInterval) {
        if (this.executed) {
            throw new IllegalStateException("Batch already executed!");
        }
        if (this.commands.isEmpty()) {
            return this.connectionManager.newSucceededFuture(null);
        }
        this.executed = true;
        RPromise<Void> voidPromise = this.connectionManager.newPromise();
        final RPromise<List<?>> promise = this.connectionManager.newPromise();
        voidPromise.addListener((FutureListener)new FutureListener<Void>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.tryFailure(future.cause());
                    CommandBatchService.this.commands = null;
                    return;
                }
                ArrayList entries = new ArrayList();
                for (Entry e : CommandBatchService.this.commands.values()) {
                    entries.addAll(e.getCommands());
                }
                Collections.sort(entries);
                ArrayList<Object> result = new ArrayList<Object>(entries.size());
                for (BatchCommandData batchCommandData : entries) {
                    Object entryResult = batchCommandData.getPromise().getNow();
                    if (CommandBatchService.this.isRedissonReferenceSupportEnabled() && entryResult instanceof RedissonReference) {
                        result.add(CommandBatchService.this.redisson != null ? RedissonObjectFactory.fromReference(CommandBatchService.this.redisson, (RedissonReference)entryResult) : RedissonObjectFactory.fromReference(CommandBatchService.this.redissonReactive, (RedissonReference)entryResult));
                        continue;
                    }
                    result.add(entryResult);
                }
                promise.trySuccess(result);
                CommandBatchService.this.commands = null;
            }
        });
        AtomicInteger slots = new AtomicInteger(this.commands.size());
        for (Map.Entry e : this.commands.entrySet()) {
            this.execute((Entry)e.getValue(), new NodeSource((MasterSlaveEntry)e.getKey()), voidPromise, slots, 0, false, responseTimeout, retryAttempts, retryInterval);
        }
        return promise;
    }

    private void execute(final Entry entry, final NodeSource source, final RPromise<Void> mainPromise, final AtomicInteger slots, final int attempt, final boolean noResult, final long responseTimeout, final int retryAttempts, final long retryInterval) {
        if (mainPromise.isCancelled()) {
            return;
        }
        if (!this.connectionManager.getShutdownLatch().acquire()) {
            mainPromise.tryFailure(new RedissonShutdownException("Redisson is shutdown"));
            return;
        }
        final RPromise attemptPromise = this.connectionManager.newPromise();
        final AsyncDetails details = new AsyncDetails();
        final RFuture<RedisConnection> connectionFuture = entry.isReadOnlyMode() ? this.connectionManager.connectionReadOp(source, null) : this.connectionManager.connectionWriteOp(source, null);
        TimerTask retryTimerTask = new TimerTask(){

            @Override
            public void run(Timeout timeout) throws Exception {
                ChannelFuture writeFuture;
                if (attemptPromise.isDone()) {
                    return;
                }
                if (connectionFuture.cancel(false)) {
                    CommandBatchService.this.connectionManager.getShutdownLatch().release();
                } else if (connectionFuture.isSuccess() && (writeFuture = details.getWriteFuture()) != null && !writeFuture.cancel(false) && writeFuture.isSuccess()) {
                    return;
                }
                if (mainPromise.isCancelled()) {
                    attemptPromise.cancel(false);
                    return;
                }
                int attempts = CommandBatchService.this.connectionManager.getConfig().getRetryAttempts();
                if (retryAttempts > 0) {
                    attempts = retryAttempts;
                }
                if (attempt == attempts) {
                    if (details.getException() == null) {
                        details.setException(new RedisTimeoutException("Batch command execution timeout"));
                    }
                    attemptPromise.tryFailure(details.getException());
                    return;
                }
                if (!attemptPromise.cancel(false)) {
                    return;
                }
                int count = attempt + 1;
                CommandBatchService.this.execute(entry, source, mainPromise, slots, count, noResult, responseTimeout, retryAttempts, retryInterval);
            }
        };
        long interval = this.connectionManager.getConfig().getRetryInterval();
        if (retryInterval > 0L) {
            interval = retryInterval;
        }
        Timeout timeout = this.connectionManager.newTimeout(retryTimerTask, interval, TimeUnit.MILLISECONDS);
        details.setTimeout(timeout);
        connectionFuture.addListener(new FutureListener<RedisConnection>(){

            @Override
            public void operationComplete(Future<RedisConnection> connFuture) throws Exception {
                CommandBatchService.this.checkConnectionFuture(entry, source, mainPromise, attemptPromise, details, connectionFuture, noResult, responseTimeout);
            }
        });
        attemptPromise.addListener(new FutureListener<Void>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                details.getTimeout().cancel();
                if (future.isCancelled()) {
                    return;
                }
                if (future.cause() instanceof RedisMovedException) {
                    RedisMovedException ex = (RedisMovedException)future.cause();
                    entry.clearErrors();
                    NodeSource nodeSource = new NodeSource(ex.getSlot(), ex.getAddr(), NodeSource.Redirect.MOVED);
                    CommandBatchService.this.execute(entry, nodeSource, mainPromise, slots, attempt, noResult, responseTimeout, retryAttempts, retryInterval);
                    return;
                }
                if (future.cause() instanceof RedisAskException) {
                    RedisAskException ex = (RedisAskException)future.cause();
                    entry.clearErrors();
                    NodeSource nodeSource = new NodeSource(ex.getSlot(), ex.getAddr(), NodeSource.Redirect.ASK);
                    CommandBatchService.this.execute(entry, nodeSource, mainPromise, slots, attempt, noResult, responseTimeout, retryAttempts, retryInterval);
                    return;
                }
                if (future.cause() instanceof RedisLoadingException) {
                    entry.clearErrors();
                    CommandBatchService.this.execute(entry, source, mainPromise, slots, attempt, noResult, responseTimeout, retryAttempts, retryInterval);
                    return;
                }
                if (future.cause() instanceof RedisTryAgainException) {
                    entry.clearErrors();
                    CommandBatchService.this.connectionManager.newTimeout(new TimerTask(){

                        @Override
                        public void run(Timeout timeout) throws Exception {
                            CommandBatchService.this.execute(entry, source, mainPromise, slots, attempt, noResult, responseTimeout, retryAttempts, retryInterval);
                        }
                    }, 1L, TimeUnit.SECONDS);
                    return;
                }
                if (future.isSuccess()) {
                    if (slots.decrementAndGet() == 0) {
                        mainPromise.trySuccess(future.getNow());
                    }
                } else {
                    mainPromise.tryFailure(future.cause());
                }
            }
        });
    }

    private void checkWriteFuture(final RPromise<Void> attemptPromise, AsyncDetails details, final RedisConnection connection, ChannelFuture future, boolean noResult, long responseTimeout) {
        if (attemptPromise.isDone() || future.isCancelled()) {
            return;
        }
        if (!future.isSuccess()) {
            details.setException(new WriteRedisConnectionException("Can't write command batch to channel: " + future.channel(), future.cause()));
        } else {
            details.getTimeout().cancel();
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run(Timeout timeout) throws Exception {
                    attemptPromise.tryFailure(new RedisTimeoutException("Redis server response timeout during command batch execution. Channel: " + connection.getChannel()));
                }
            };
            long timeout = this.connectionManager.getConfig().getTimeout();
            if (responseTimeout > 0L) {
                timeout = responseTimeout;
            }
            Timeout timeoutTask = this.connectionManager.newTimeout(timerTask, timeout, TimeUnit.MILLISECONDS);
            details.setTimeout(timeoutTask);
        }
    }

    private void checkConnectionFuture(Entry entry, NodeSource source, RPromise<Void> mainPromise, final RPromise<Void> attemptPromise, final AsyncDetails details, RFuture<RedisConnection> connFuture, final boolean noResult, final long responseTimeout) {
        if (attemptPromise.isDone() || mainPromise.isCancelled() || connFuture.isCancelled()) {
            return;
        }
        if (!connFuture.isSuccess()) {
            this.connectionManager.getShutdownLatch().release();
            details.setException(this.convertException(connFuture));
            return;
        }
        final RedisConnection connection = connFuture.getNow();
        ArrayList list = new ArrayList(entry.getCommands().size() + 1);
        if (source.getRedirect() == NodeSource.Redirect.ASK) {
            RPromise promise = this.connectionManager.newPromise();
            list.add(new CommandData(promise, StringCodec.INSTANCE, RedisCommands.ASKING, new Object[0]));
        }
        for (BatchCommandData batchCommandData : entry.getCommands()) {
            if (batchCommandData.getPromise().isSuccess()) continue;
            list.add(batchCommandData);
        }
        ChannelFuture future = connection.send(new CommandsData(attemptPromise, list, noResult));
        details.setWriteFuture(future);
        details.getWriteFuture().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                CommandBatchService.this.checkWriteFuture(attemptPromise, details, connection, future, noResult, responseTimeout);
            }
        });
        this.releaseConnection(source, connFuture, entry.isReadOnlyMode(), attemptPromise, details);
    }

    public static class Entry {
        Deque<BatchCommandData<?, ?>> commands = new LinkedBlockingDeque();
        volatile boolean readOnlyMode = true;

        public Deque<BatchCommandData<?, ?>> getCommands() {
            return this.commands;
        }

        public void setReadOnlyMode(boolean readOnlyMode) {
            this.readOnlyMode = readOnlyMode;
        }

        public boolean isReadOnlyMode() {
            return this.readOnlyMode;
        }

        public void clearErrors() {
            for (BatchCommandData<?, ?> commandEntry : this.commands) {
                commandEntry.clearError();
            }
        }
    }
}

