/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.codec;

import reactor.fn.Consumer;
import reactor.fn.Function;
import reactor.io.buffer.Buffer;
import reactor.io.codec.BufferCodec;
import reactor.io.codec.Frame;

public class FrameCodec
extends BufferCodec<Frame, Frame> {
    private final LengthField lengthField;
    private final int prefixLength;
    private final int minRequiredLen;

    public FrameCodec(int prefixLength, LengthField lengthField) {
        this.prefixLength = prefixLength;
        this.lengthField = lengthField;
        this.minRequiredLen = FrameCodec.lengthFieldLength(lengthField) + prefixLength;
    }

    @Override
    public Function<Buffer, Frame> decoder(Consumer<Frame> next) {
        return new FrameDecoder(next);
    }

    @Override
    public Buffer apply(Frame frame) {
        return null;
    }

    private static int lengthFieldLength(LengthField lf) {
        switch (lf) {
            case SHORT: {
                return 2;
            }
            case INT: {
                return 4;
            }
        }
        return 8;
    }

    private class FrameDecoder
    implements Function<Buffer, Frame> {
        private final Consumer<Frame> next;

        private FrameDecoder(Consumer<Frame> next) {
            this.next = next;
        }

        @Override
        public Frame apply(Buffer buffer) {
            while (buffer.remaining() > FrameCodec.this.minRequiredLen) {
                int pos = buffer.position();
                int limit = buffer.limit();
                Buffer.View prefix = this.readPrefix(buffer);
                if (null == prefix) {
                    buffer.limit(limit);
                    buffer.position(pos);
                    return null;
                }
                Buffer.View data = this.readData(buffer);
                if (null == data) {
                    buffer.limit(limit);
                    buffer.position(pos);
                    return null;
                }
                Buffer prefixBuff = new Buffer(FrameCodec.this.prefixLength, true).append(prefix.get()).flip();
                Buffer dataBuff = new Buffer(data.getEnd() - data.getStart(), true).append(data.get()).flip();
                buffer.limit(limit);
                Frame f = new Frame(prefixBuff, dataBuff);
                if (null != this.next) {
                    this.next.accept(f);
                    continue;
                }
                return f;
            }
            return null;
        }

        private Buffer.View readPrefix(Buffer buffer) {
            if (buffer.remaining() < FrameCodec.this.prefixLength) {
                return null;
            }
            int pos = buffer.position();
            Buffer.View prefix = buffer.createView(pos, pos + FrameCodec.this.prefixLength);
            buffer.position(pos + FrameCodec.this.prefixLength);
            return prefix;
        }

        private int readLen(Buffer buffer) {
            switch (FrameCodec.this.lengthField) {
                case SHORT: {
                    if (buffer.remaining() <= 2) break;
                    return buffer.readShort();
                }
                case INT: {
                    if (buffer.remaining() <= 4) break;
                    return buffer.readInt();
                }
                case LONG: {
                    if (buffer.remaining() <= 8) break;
                    return (int)buffer.readLong();
                }
            }
            return -1;
        }

        private Buffer.View readData(Buffer buffer) {
            int pos = buffer.position();
            int limit = buffer.limit();
            int len = this.readLen(buffer);
            if (len == -1 || buffer.remaining() < len) {
                buffer.limit(limit);
                buffer.position(pos);
                return null;
            }
            pos = buffer.position();
            Buffer.View data = buffer.createView(pos, pos + len);
            buffer.position(pos + len);
            return data;
        }
    }

    public static enum LengthField {
        SHORT,
        INT,
        LONG;

    }
}

