/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.eviction;

import io.netty.util.internal.PlatformDependent;
import java.util.concurrent.ConcurrentMap;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.eviction.EvictionTask;
import org.redisson.eviction.JCacheEvictionTask;
import org.redisson.eviction.MapCacheEvictionTask;
import org.redisson.eviction.MultimapEvictionTask;
import org.redisson.eviction.SetCacheEvictionTask;

public class EvictionScheduler {
    private final ConcurrentMap<String, EvictionTask> tasks = PlatformDependent.newConcurrentHashMap();
    private final CommandAsyncExecutor executor;

    public EvictionScheduler(CommandAsyncExecutor executor) {
        this.executor = executor;
    }

    public void scheduleCleanMultimap(String name, String timeoutSetName) {
        MultimapEvictionTask task = new MultimapEvictionTask(name, timeoutSetName, this.executor);
        EvictionTask prevTask = this.tasks.putIfAbsent(name, task);
        if (prevTask == null) {
            ((EvictionTask)task).schedule();
        }
    }

    public void scheduleJCache(String name, String timeoutSetName, String expiredChannelName) {
        JCacheEvictionTask task = new JCacheEvictionTask(name, timeoutSetName, expiredChannelName, this.executor);
        EvictionTask prevTask = this.tasks.putIfAbsent(name, task);
        if (prevTask == null) {
            ((EvictionTask)task).schedule();
        }
    }

    public void schedule(String name) {
        SetCacheEvictionTask task = new SetCacheEvictionTask(name, this.executor);
        EvictionTask prevTask = this.tasks.putIfAbsent(name, task);
        if (prevTask == null) {
            ((EvictionTask)task).schedule();
        }
    }

    public void schedule(String name, String timeoutSetName, String maxIdleSetName) {
        MapCacheEvictionTask task = new MapCacheEvictionTask(name, timeoutSetName, maxIdleSetName, this.executor);
        EvictionTask prevTask = this.tasks.putIfAbsent(name, task);
        if (prevTask == null) {
            ((EvictionTask)task).schedule();
        }
    }
}

