/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.redisson.RedissonBlockingQueue;
import org.redisson.RedissonDeque;
import org.redisson.api.Entry;
import org.redisson.api.RBlockingDeque;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonClient;
import org.redisson.api.queue.DequeMoveArgs;
import org.redisson.api.queue.DequeMoveParams;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonBlockingDeque<V>
extends RedissonDeque<V>
implements RBlockingDeque<V> {
    private final RedissonBlockingQueue<V> blockingQueue;

    public RedissonBlockingDeque(CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(commandExecutor, name, redisson);
        this.blockingQueue = new RedissonBlockingQueue(commandExecutor, name, redisson);
    }

    public RedissonBlockingDeque(Codec codec, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(codec, commandExecutor, name, redisson);
        this.blockingQueue = new RedissonBlockingQueue(codec, commandExecutor, name, redisson);
    }

    @Override
    public RFuture<Void> putAsync(V e) {
        return this.addAsync(e, RedisCommands.RPUSH_VOID);
    }

    @Override
    public void put(V e) throws InterruptedException {
        this.get(this.putAsync(e));
    }

    @Override
    public boolean offer(V e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offer(e);
    }

    @Override
    public RFuture<V> takeAsync() {
        return this.blockingQueue.takeAsync();
    }

    @Override
    public V take() throws InterruptedException {
        return this.blockingQueue.take();
    }

    @Override
    public RFuture<V> pollAsync(long timeout, TimeUnit unit) {
        return this.blockingQueue.pollAsync(timeout, unit);
    }

    @Override
    public V poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.blockingQueue.poll(timeout, unit);
    }

    @Override
    public V pollFromAny(long timeout, TimeUnit unit, String ... queueNames) throws InterruptedException {
        return this.blockingQueue.pollFromAny(timeout, unit, new String[0]);
    }

    @Override
    public RFuture<V> pollFromAnyAsync(long timeout, TimeUnit unit, String ... queueNames) {
        return this.blockingQueue.pollFromAnyAsync(timeout, unit, new String[0]);
    }

    @Override
    public Entry<String, V> pollFromAnyWithName(Duration timeout, String ... queueNames) throws InterruptedException {
        return this.blockingQueue.pollFromAnyWithName(timeout, queueNames);
    }

    @Override
    public RFuture<Entry<String, V>> pollFromAnyWithNameAsync(Duration timeout, String ... queueNames) {
        return this.blockingQueue.pollFromAnyWithNameAsync(timeout, queueNames);
    }

    @Override
    public RFuture<V> pollLastAndOfferFirstToAsync(String queueName, long timeout, TimeUnit unit) {
        return this.blockingQueue.pollLastAndOfferFirstToAsync(queueName, timeout, unit);
    }

    @Override
    public V pollLastAndOfferFirstTo(String queueName, long timeout, TimeUnit unit) throws InterruptedException {
        return this.blockingQueue.pollLastAndOfferFirstTo(queueName, timeout, unit);
    }

    @Override
    public Map<String, List<V>> pollFirstFromAny(Duration duration, int count, String ... queueNames) throws InterruptedException {
        return this.blockingQueue.pollFirstFromAny(duration, count, queueNames);
    }

    @Override
    public Map<String, List<V>> pollLastFromAny(Duration duration, int count, String ... queueNames) throws InterruptedException {
        return this.blockingQueue.pollLastFromAny(duration, count, queueNames);
    }

    @Override
    public RFuture<Map<String, List<V>>> pollFirstFromAnyAsync(Duration duration, int count, String ... queueNames) {
        return this.blockingQueue.pollFirstFromAnyAsync(duration, count, queueNames);
    }

    @Override
    public RFuture<Map<String, List<V>>> pollLastFromAnyAsync(Duration duration, int count, String ... queueNames) {
        return this.blockingQueue.pollLastFromAnyAsync(duration, count, queueNames);
    }

    @Override
    public V takeLastAndOfferFirstTo(String queueName) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.takeLastAndOfferFirstToAsync(queueName));
    }

    @Override
    public int subscribeOnElements(Consumer<V> consumer) {
        return this.blockingQueue.subscribeOnElements(consumer);
    }

    @Override
    public void unsubscribe(int id) {
        this.blockingQueue.unsubscribe(id);
    }

    @Override
    public RFuture<V> takeLastAndOfferFirstToAsync(String queueName) {
        return this.pollLastAndOfferFirstToAsync(queueName, 0L, TimeUnit.SECONDS);
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int drainTo(Collection<? super V> c) {
        return this.blockingQueue.drainTo(c);
    }

    @Override
    public RFuture<Integer> drainToAsync(Collection<? super V> c) {
        return this.blockingQueue.drainToAsync(c);
    }

    @Override
    public int drainTo(Collection<? super V> c, int maxElements) {
        return this.blockingQueue.drainTo(c, maxElements);
    }

    @Override
    public RFuture<Integer> drainToAsync(Collection<? super V> c, int maxElements) {
        return this.blockingQueue.drainToAsync(c, maxElements);
    }

    @Override
    public RFuture<Void> putFirstAsync(V e) {
        return this.addFirstAsync(e);
    }

    @Override
    public RFuture<Void> putLastAsync(V e) {
        return this.addLastAsync(e);
    }

    @Override
    public void putFirst(V e) throws InterruptedException {
        this.addFirst(e);
    }

    @Override
    public void putLast(V e) throws InterruptedException {
        this.addLast(e);
    }

    @Override
    public boolean offerFirst(V e, long timeout, TimeUnit unit) throws InterruptedException {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(V e, long timeout, TimeUnit unit) throws InterruptedException {
        this.addLast(e);
        return true;
    }

    @Override
    public V takeFirst() throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.takeFirstAsync());
    }

    @Override
    public RFuture<V> takeFirstAsync() {
        return this.takeAsync();
    }

    @Override
    public RFuture<V> takeLastAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.BRPOP_VALUE, this.getRawName(), 0);
    }

    @Override
    public V takeLast() throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.takeLastAsync());
    }

    @Override
    public RFuture<V> pollFirstAsync(long timeout, TimeUnit unit) {
        return this.pollAsync(timeout, unit);
    }

    @Override
    public V pollFirstFromAny(long timeout, TimeUnit unit, String ... queueNames) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.pollFirstFromAnyAsync(timeout, unit, queueNames));
    }

    @Override
    public RFuture<V> pollFirstFromAnyAsync(long timeout, TimeUnit unit, String ... queueNames) {
        return this.pollFromAnyAsync(timeout, unit, queueNames);
    }

    @Override
    public V pollLastFromAny(long timeout, TimeUnit unit, String ... queueNames) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.pollLastFromAnyAsync(timeout, unit, queueNames));
    }

    @Override
    public int subscribeOnFirstElements(Consumer<V> consumer) {
        return this.commandExecutor.getServiceManager().getElementsSubscribeService().subscribeOnElements(this::takeFirstAsync, consumer);
    }

    @Override
    public int subscribeOnLastElements(Consumer<V> consumer) {
        return this.commandExecutor.getServiceManager().getElementsSubscribeService().subscribeOnElements(this::takeLastAsync, consumer);
    }

    @Override
    public RFuture<V> pollLastFromAnyAsync(long timeout, TimeUnit unit, String ... queueNames) {
        return this.commandExecutor.pollFromAnyAsync(this.getRawName(), this.codec, RedisCommands.BRPOP_VALUE, this.toSeconds(timeout, unit), queueNames);
    }

    @Override
    public V pollFirst(long timeout, TimeUnit unit) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.pollFirstAsync(timeout, unit));
    }

    @Override
    public RFuture<V> pollLastAsync(long timeout, TimeUnit unit) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.BRPOP_VALUE, this.getRawName(), this.toSeconds(timeout, unit));
    }

    @Override
    public V pollLast(long timeout, TimeUnit unit) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.pollLastAsync(timeout, unit));
    }

    @Override
    public V move(Duration timeout, DequeMoveArgs args) {
        return this.get(this.moveAsync(timeout, args));
    }

    @Override
    public RFuture<V> moveAsync(Duration timeout, DequeMoveArgs args) {
        DequeMoveParams pp = (DequeMoveParams)args;
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.BLMOVE, new Object[]{this.getRawName(), pp.getDestName(), pp.getSourceDirection(), pp.getDestDirection(), this.toSeconds(timeout.getSeconds(), TimeUnit.SECONDS)});
    }
}

