/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol.decoder;

import java.util.LinkedHashMap;
import java.util.List;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class ObjectMapDecoder
implements MultiDecoder<Object> {
    private final boolean decodeList;

    public ObjectMapDecoder(boolean decodeList) {
        this.decodeList = decodeList;
    }

    @Override
    public Decoder<Object> getDecoder(Codec codec, int paramNum, State state) {
        if (state.getValue() != null && ((Boolean)state.getValue()).booleanValue()) {
            return codec.getMapKeyDecoder();
        }
        if (paramNum % 2 == 0) {
            return codec.getMapKeyDecoder();
        }
        return codec.getMapValueDecoder();
    }

    @Override
    public Object decode(List<Object> parts, State state) {
        if (this.decodeList && state.getValue() != null && ((Boolean)state.getValue()).booleanValue()) {
            return parts;
        }
        LinkedHashMap<Object, Object> result = MultiDecoder.newLinkedHashMap(parts.size() / 2);
        for (int i = 0; i < parts.size(); ++i) {
            if (i % 2 == 0) continue;
            result.put(parts.get(i - 1), parts.get(i));
        }
        state.setValue(true);
        return result;
    }
}

