/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import org.redisson.codec.FstCodec;

public class LZ4Codec
implements Codec {
    private final LZ4Factory factory = LZ4Factory.fastestInstance();
    private final Codec innerCodec;
    private final Decoder<Object> decoder = new Decoder<Object>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            byte[] bytes = new byte[buf.readableBytes()];
            buf.readBytes(bytes);
            LZ4SafeDecompressor decompressor = LZ4Codec.this.factory.safeDecompressor();
            bytes = decompressor.decompress(bytes, bytes.length * 3);
            ByteBuf bf = Unpooled.wrappedBuffer(bytes);
            try {
                Object object = LZ4Codec.this.innerCodec.getValueDecoder().decode(bf, state);
                return object;
            }
            finally {
                bf.release();
            }
        }
    };
    private final Encoder encoder = new Encoder(){

        @Override
        public byte[] encode(Object in) throws IOException {
            LZ4Compressor compressor = LZ4Codec.this.factory.fastCompressor();
            byte[] bytes = LZ4Codec.this.innerCodec.getValueEncoder().encode(in);
            return compressor.compress(bytes);
        }
    };

    public LZ4Codec() {
        this(new FstCodec());
    }

    public LZ4Codec(Codec innerCodec) {
        this.innerCodec = innerCodec;
    }

    @Override
    public Decoder<Object> getMapValueDecoder() {
        return this.getValueDecoder();
    }

    @Override
    public Encoder getMapValueEncoder() {
        return this.getValueEncoder();
    }

    @Override
    public Decoder<Object> getMapKeyDecoder() {
        return this.getValueDecoder();
    }

    @Override
    public Encoder getMapKeyEncoder() {
        return this.getValueEncoder();
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }
}

