/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.combination;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Dispatcher;
import reactor.core.reactivestreams.SerializedSubscriber;
import reactor.core.support.Exceptions;
import reactor.core.support.NonBlocking;
import reactor.rx.action.Action;
import reactor.rx.action.Signal;
import reactor.rx.subscription.PushSubscription;

public final class ConcatAction<T>
extends Action<Publisher<? extends T>, T> {
    private final ConcurrentLinkedQueue<Signal<Publisher<? extends T>>> queue = new ConcurrentLinkedQueue();
    volatile int wip;
    static final AtomicIntegerFieldUpdater<ConcatAction> WIP_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ConcatAction.class, "wip");
    private volatile long requested;
    private static final AtomicLongFieldUpdater<ConcatAction> REQUESTED_UPDATER = AtomicLongFieldUpdater.newUpdater(ConcatAction.class, "requested");
    volatile ConcatInnerSubscriber currentSubscriber;

    @Override
    protected void doNext(Publisher<? extends T> ev) {
        this.queue.add(Signal.next(ev));
        if (WIP_UPDATER.getAndIncrement(this) == 0) {
            this.subscribeNext();
        }
    }

    @Override
    public void onComplete() {
        try {
            this.queue.add(Signal.complete());
            if (WIP_UPDATER.getAndIncrement(this) == 0) {
                this.subscribeNext();
            }
        }
        catch (Exception e) {
            this.doError(e);
        }
    }

    @Override
    protected void doOnSubscribe(Subscription subscription) {
        this.requestMore(1L);
    }

    @Override
    public void subscribe(Subscriber<? super T> subscriber) {
        super.subscribe(SerializedSubscriber.create(subscriber));
    }

    @Override
    protected void requestUpstream(long capacity, boolean terminated, long elements) {
        this.requestFromChild(elements);
    }

    private void requestFromChild(long n) {
        if (REQUESTED_UPDATER.getAndAdd(this, n) == 0L && this.currentSubscriber == null && this.wip > 0) {
            this.subscribeNext();
            return;
        }
        ConcatInnerSubscriber subscriber = this.currentSubscriber;
        if (subscriber != null) {
            subscriber.requestMore(n);
        }
    }

    @Override
    protected void subscribeWithSubscription(Subscriber<? super T> subscriber, PushSubscription<T> subscription) {
        try {
            if (!this.addSubscription(subscription)) {
                subscriber.onError(new IllegalStateException("The subscription cannot be linked to this Stream"));
            } else {
                subscription.markAsDeferredStart();
                subscription.start();
            }
        }
        catch (Exception e) {
            Exceptions.throwIfFatal(e);
            subscriber.onError(e);
        }
    }

    @Override
    public void cancel() {
        this.queue.clear();
        super.cancel();
    }

    private void decrementRequested() {
        if (this.requested != Long.MAX_VALUE) {
            REQUESTED_UPDATER.decrementAndGet(this);
        }
    }

    void completeInner() {
        this.currentSubscriber = null;
        if (WIP_UPDATER.decrementAndGet(this) > 0) {
            this.subscribeNext();
        }
        this.requestMore(1L);
    }

    void subscribeNext() {
        if (this.requested > 0L) {
            Signal<Publisher<T>> o = this.queue.poll();
            if (o == null) {
                return;
            }
            if (o.isOnComplete()) {
                this.broadcastComplete();
            } else {
                Publisher<T> source = o.get();
                this.currentSubscriber = new ConcatInnerSubscriber();
                source.subscribe(this.currentSubscriber);
            }
        } else {
            Signal<Publisher<T>> o = this.queue.peek();
            if (o != null && o.isOnComplete()) {
                this.broadcastComplete();
            }
        }
    }

    class ConcatInnerSubscriber
    implements Subscriber<T>,
    NonBlocking {
        private Subscription s;

        ConcatInnerSubscriber() {
        }

        void requestMore(long n) {
            if (this.s != null) {
                this.s.request(n);
            }
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.s = s;
            if (ConcatAction.this.requested > 0L) {
                s.request(ConcatAction.this.requested);
            }
        }

        @Override
        public void onNext(T t) {
            ConcatAction.this.decrementRequested();
            ConcatAction.this.broadcastNext(t);
        }

        @Override
        public void onError(Throwable e) {
            Subscription s = this.s;
            if (s != null) {
                s.cancel();
            }
            ConcatAction.this.onError(e);
        }

        @Override
        public void onComplete() {
            Subscription s = this.s;
            if (s != null) {
                s.cancel();
            }
            ConcatAction.this.completeInner();
        }

        @Override
        public long getCapacity() {
            return Long.MAX_VALUE;
        }

        @Override
        public boolean isReactivePull(Dispatcher dispatcher, long producerCapacity) {
            return false;
        }
    }
}

