/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.jcache.configuration;

import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;

public class JCacheConfiguration<K, V>
implements CompleteConfiguration<K, V> {
    private static final long serialVersionUID = -7861479608049089078L;
    private final ExpiryPolicy expiryPolicy;
    private final MutableConfiguration<K, V> delegate;

    public JCacheConfiguration(Configuration<K, V> configuration) {
        if (configuration != null) {
            if (configuration instanceof CompleteConfiguration) {
                this.delegate = new MutableConfiguration((CompleteConfiguration)configuration);
            } else {
                this.delegate = new MutableConfiguration();
                this.delegate.setStoreByValue(configuration.isStoreByValue());
                this.delegate.setTypes(configuration.getKeyType(), configuration.getValueType());
            }
        } else {
            this.delegate = new MutableConfiguration();
        }
        this.expiryPolicy = this.delegate.getExpiryPolicyFactory().create();
    }

    @Override
    public Class<K> getKeyType() {
        if (this.delegate.getKeyType() == null) {
            return Object.class;
        }
        return this.delegate.getKeyType();
    }

    @Override
    public Class<V> getValueType() {
        if (this.delegate.getValueType() == null) {
            return Object.class;
        }
        return this.delegate.getValueType();
    }

    @Override
    public boolean isStoreByValue() {
        return this.delegate.isStoreByValue();
    }

    @Override
    public boolean isReadThrough() {
        return this.delegate.isReadThrough();
    }

    @Override
    public boolean isWriteThrough() {
        return this.delegate.isWriteThrough();
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.delegate.isStatisticsEnabled();
    }

    public void setStatisticsEnabled(boolean enabled) {
        this.delegate.setStatisticsEnabled(enabled);
    }

    public void setManagementEnabled(boolean enabled) {
        this.delegate.setManagementEnabled(enabled);
    }

    @Override
    public boolean isManagementEnabled() {
        return this.delegate.isManagementEnabled();
    }

    @Override
    public Iterable<CacheEntryListenerConfiguration<K, V>> getCacheEntryListenerConfigurations() {
        return this.delegate.getCacheEntryListenerConfigurations();
    }

    public void addCacheEntryListenerConfiguration(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.delegate.addCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
    }

    public void removeCacheEntryListenerConfiguration(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.delegate.removeCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
    }

    @Override
    public Factory<CacheLoader<K, V>> getCacheLoaderFactory() {
        return this.delegate.getCacheLoaderFactory();
    }

    @Override
    public Factory<CacheWriter<? super K, ? super V>> getCacheWriterFactory() {
        return this.delegate.getCacheWriterFactory();
    }

    @Override
    public Factory<ExpiryPolicy> getExpiryPolicyFactory() {
        return this.delegate.getExpiryPolicyFactory();
    }

    public ExpiryPolicy getExpiryPolicy() {
        return this.expiryPolicy;
    }
}

