/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.RedissonList;
import org.redisson.api.RFuture;
import org.redisson.api.RList;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.BooleanReplayConvertor;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.client.protocol.convertor.IntegerReplayConvertor;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonSubList<V>
extends RedissonList<V>
implements RList<V> {
    public static final RedisCommand<Boolean> EVAL_BOOLEAN_ARGS2 = new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 5, RedisCommand.ValueType.OBJECTS);
    final int fromIndex;
    AtomicInteger toIndex = new AtomicInteger();
    int size = -1;

    protected RedissonSubList(Codec codec, CommandAsyncExecutor commandExecutor, String name, int fromIndex, int toIndex) {
        super(codec, commandExecutor, name);
        this.fromIndex = fromIndex;
        this.toIndex.set(toIndex);
    }

    @Override
    public RFuture<Integer> sizeAsync() {
        if (this.size != -1) {
            return this.newSucceededFuture(this.size);
        }
        return this.commandExecutor.readAsync(this.getName(), this.codec, new RedisStrictCommand<Integer>("LLEN", new IntegerReplayConvertor(){

            @Override
            public Integer convert(Object obj) {
                int size = ((Long)obj).intValue();
                int subListLen = Math.min(size, RedissonSubList.this.toIndex.get()) - RedissonSubList.this.fromIndex;
                return Math.max(subListLen, 0);
            }
        }), this.getName());
    }

    @Override
    public RFuture<List<V>> readAllAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.LRANGE, this.getName(), this.fromIndex, this.toIndex.get() - 1);
    }

    @Override
    public RFuture<Boolean> addAsync(V e) {
        return this.addAllAsync(this.toIndex.get() - this.fromIndex, Collections.singleton(e));
    }

    @Override
    public RFuture<Boolean> removeAsync(Object o) {
        return this.removeAllAsync(Collections.singleton(o), 1);
    }

    @Override
    public RFuture<Boolean> containsAllAsync(Collection<?> c) {
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(this.fromIndex);
        params.add(this.toIndex.get() - 1);
        params.addAll(c);
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 6, RedisCommand.ValueType.OBJECTS), "local fromIndex = table.remove(ARGV, 1);local toIndex = table.remove(ARGV, 2);local items = redis.call('lrange', KEYS[1], tonumber(fromIndex), tonumber(toIndex)) for i=1, #items do for j = 1, #ARGV, 1 do if items[i] == ARGV[j] then table.remove(ARGV, j) end end end return #ARGV == 0 and 1 or 0", Collections.singletonList(this.getName()), params.toArray());
    }

    @Override
    public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return this.newSucceededFuture(false);
        }
        return this.addAllAsync(this.toIndex.get() - this.fromIndex, c);
    }

    @Override
    public RFuture<Boolean> addAllAsync(int index, Collection<? extends V> coll) {
        this.checkIndex(index);
        if (coll.isEmpty()) {
            return this.newSucceededFuture(false);
        }
        if (index == 0) {
            ArrayList<V> elements = new ArrayList<V>(coll);
            Collections.reverse(elements);
            elements.add(0, this.getName());
            return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.LPUSH_BOOLEAN, elements.toArray());
        }
        ArrayList<Integer> args = new ArrayList<Integer>(coll.size() + 1);
        args.add(index);
        args.addAll(coll);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, EVAL_BOOLEAN_ARGS2, "local ind = table.remove(ARGV, 1); local size = redis.call('llen', KEYS[1]); assert(tonumber(ind) <= size, 'index: ' .. ind .. ' but current size: ' .. size); local tail = redis.call('lrange', KEYS[1], ind, -1); redis.call('ltrim', KEYS[1], 0, ind - 1); for i=1, #ARGV, 5000 do redis.call('rpush', KEYS[1], unpack(ARGV, i, math.min(i+4999, #ARGV))); end; if #tail > 0 then for i=1, #tail, 5000 do redis.call('rpush', KEYS[1], unpack(tail, i, math.min(i+4999, #tail))); end end;return 1;", Collections.singletonList(this.getName()), args.toArray());
    }

    @Override
    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        return this.removeAllAsync(c, 0);
    }

    private RFuture<Boolean> removeAllAsync(Collection<?> c, int count) {
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(this.fromIndex);
        params.add(this.toIndex.get() - 1);
        params.add(count);
        params.addAll(c);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 7, RedisCommand.ValueType.OBJECTS), "local v = 0; local fromIndex = table.remove(ARGV, 1);local toIndex = table.remove(ARGV, 2);local count = table.remove(ARGV, 3);local items = redis.call('lrange', KEYS[1], fromIndex, toIndex); for i=1, #items do for j = 1, #ARGV, 1 do if items[i] == ARGV[j] then redis.call('lrem', KEYS[1], count, ARGV[i]); v = 1; end; end; end; return v; ", Collections.singletonList(this.getName()), params.toArray());
    }

    @Override
    public RFuture<Boolean> retainAllAsync(Collection<?> c) {
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(this.fromIndex);
        params.add(this.toIndex.get() - 1);
        params.addAll(c);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN_WITH_VALUES, "local changed = 0 local fromIndex = table.remove(ARGV, 1);local toIndex = table.remove(ARGV, 2);local items = redis.call('lrange', KEYS[1], fromIndex, toIndex) local i = 1 while i <= #items do local element = items[i] local isInAgrs = false for j = 1, #ARGV, 1 do if ARGV[j] == element then isInAgrs = true break end end if isInAgrs == false then redis.call('LREM', KEYS[1], 0, element) changed = 1 end i = i + 1 end return changed ", Collections.singletonList(this.getName()), params.toArray());
    }

    @Override
    public void clear() {
        if (this.fromIndex == 0) {
            this.get(this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.LTRIM, this.getName(), this.toIndex, -1));
            this.size = 0;
            return;
        }
        this.get(this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_VOID, "local tail = redis.call('lrange', KEYS[1], ARGV[2], -1); redis.call('ltrim', KEYS[1], 0, ARGV[1] - 1); if #tail > 0 then for i=1, #tail, 5000 do redis.call('rpush', KEYS[1], unpack(tail, i, math.min(i+4999, #tail))); end end;", Collections.singletonList(this.getName()), this.fromIndex, this.toIndex));
        this.size = 0;
    }

    @Override
    public RFuture<V> getAsync(int index) {
        this.checkIndex(index);
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.LINDEX, this.getName(), index);
    }

    @Override
    public V get(int index) {
        return this.getValue(index);
    }

    @Override
    V getValue(int index) {
        return this.get(this.getAsync(index));
    }

    private void checkIndex(int index) {
        if (index < this.fromIndex || index >= this.toIndex.get()) {
            throw new IndexOutOfBoundsException("index: " + index + " but current fromIndex: " + this.fromIndex + " toIndex: " + this.toIndex);
        }
    }

    @Override
    public V set(int index, V element) {
        return this.get(this.setAsync(index, element));
    }

    @Override
    public RFuture<V> setAsync(int index, V element) {
        this.checkIndex(index);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, new RedisCommand("EVAL", 5), "local v = redis.call('lindex', KEYS[1], ARGV[1]); redis.call('lset', KEYS[1], ARGV[1], ARGV[2]); return v", Collections.singletonList(this.getName()), index, element);
    }

    @Override
    public void fastSet(int index, V element) {
        this.get(this.fastSetAsync(index, element));
    }

    @Override
    public RFuture<Void> fastSetAsync(int index, V element) {
        this.checkIndex(index);
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.LSET, this.getName(), index, element);
    }

    @Override
    public void add(int index, V element) {
        this.addAll(index, Collections.singleton(element));
    }

    @Override
    public V remove(int index) {
        this.checkIndex(index);
        V v = this.removeInner(index);
        this.toIndex.decrementAndGet();
        return v;
    }

    private V removeInner(int index) {
        if (index == 0) {
            RFuture f = this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.LPOP, this.getName());
            return (V)this.get(f);
        }
        RFuture f = this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_OBJECT, "local v = redis.call('lindex', KEYS[1], ARGV[1]); local tail = redis.call('lrange', KEYS[1], ARGV[1] + 1, -1);redis.call('ltrim', KEYS[1], 0, ARGV[1] - 1);if #tail > 0 then for i=1, #tail, 5000 do redis.call('rpush', KEYS[1], unpack(tail, i, math.min(i+4999, #tail))); end end;return v", Collections.singletonList(this.getName()), this.fromIndex + index);
        return (V)this.get(f);
    }

    @Override
    public <R> RFuture<R> indexOfAsync(Object o, Convertor<R> convertor) {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, new RedisCommand<R>("EVAL", convertor, 4), "local items = redis.call('lrange', KEYS[1], tonumber(ARGV[2]), tonumber(ARGV[3])) for i=1,#items do if items[i] == ARGV[1] then return tonumber(ARGV[2]) + i - 1; end; end; return -1; ", Collections.singletonList(this.getName()), o, this.fromIndex, this.toIndex.get() - 1);
    }

    @Override
    public RFuture<Integer> lastIndexOfAsync(Object o) {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, new RedisCommand<Integer>("EVAL", new IntegerReplayConvertor(), 4), "local key = KEYS[1] local obj = ARGV[1] local fromIndex = table.remove(ARGV, 1);local toIndex = table.remove(ARGV, 2);local items = redis.call('lrange', key, tonumber(fromIndex), tonumber(toIndexs)) for i = #items, 0, -1 do if items[i] == obj then return tonumber(ARGV[2]) + i - 1 end; end; return -1; ", Collections.singletonList(this.getName()), o, this.fromIndex, this.toIndex.get() - 1);
    }

    @Override
    public ListIterator<V> listIterator() {
        return this.listIterator(this.fromIndex);
    }

    @Override
    public ListIterator<V> listIterator(final int fromIndex) {
        this.checkIndex(fromIndex);
        return new ListIterator<V>(){
            private V prevCurrentValue;
            private V nextCurrentValue;
            private V currentValueHasRead;
            private int currentIndex;
            private boolean hasBeenModified;
            {
                this.currentIndex = fromIndex - 1;
                this.hasBeenModified = true;
            }

            @Override
            public boolean hasNext() {
                if (this.currentIndex == RedissonSubList.this.toIndex.get() - 1) {
                    return false;
                }
                Object val = RedissonSubList.this.getValue(this.currentIndex + 1);
                if (val != null) {
                    this.nextCurrentValue = val;
                }
                return val != null;
            }

            @Override
            public V next() {
                if (this.nextCurrentValue == null && !this.hasNext()) {
                    throw new NoSuchElementException("No such element at index " + this.currentIndex);
                }
                ++this.currentIndex;
                this.currentValueHasRead = this.nextCurrentValue;
                this.nextCurrentValue = null;
                this.hasBeenModified = false;
                return this.currentValueHasRead;
            }

            @Override
            public void remove() {
                if (this.currentValueHasRead == null) {
                    throw new IllegalStateException("Neither next nor previous have been called");
                }
                if (this.hasBeenModified) {
                    throw new IllegalStateException("Element been already deleted");
                }
                RedissonSubList.this.removeInner(this.currentIndex - fromIndex);
                RedissonSubList.this.toIndex.decrementAndGet();
                this.hasBeenModified = true;
                this.currentValueHasRead = null;
            }

            @Override
            public boolean hasPrevious() {
                if (this.currentIndex <= fromIndex - 1) {
                    return false;
                }
                Object val = RedissonSubList.this.getValue(this.currentIndex);
                if (val != null) {
                    this.prevCurrentValue = val;
                }
                return val != null;
            }

            @Override
            public V previous() {
                if (this.prevCurrentValue == null && !this.hasPrevious()) {
                    throw new NoSuchElementException("No such element at index " + this.currentIndex);
                }
                --this.currentIndex;
                this.hasBeenModified = false;
                this.currentValueHasRead = this.prevCurrentValue;
                this.prevCurrentValue = null;
                return this.currentValueHasRead;
            }

            @Override
            public int nextIndex() {
                return this.currentIndex + 1;
            }

            @Override
            public int previousIndex() {
                return this.currentIndex;
            }

            @Override
            public void set(V e) {
                if (this.hasBeenModified) {
                    throw new IllegalStateException();
                }
                RedissonSubList.this.set(this.currentIndex, e);
            }

            @Override
            public void add(V e) {
                RedissonSubList.this.add(this.currentIndex + 1, e);
                ++this.currentIndex;
                this.hasBeenModified = true;
            }
        };
    }

    @Override
    public RList<V> subList(int fromIndex, int toIndex) {
        if (fromIndex < this.fromIndex || toIndex >= this.toIndex.get()) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " toIndex: " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex: " + fromIndex + " toIndex: " + toIndex);
        }
        return new RedissonSubList<V>(this.codec, this.commandExecutor, this.getName(), fromIndex, toIndex);
    }

    @Override
    public RFuture<Void> trimAsync(long fromIndex, long toIndex) {
        if (fromIndex < (long)this.fromIndex || toIndex >= (long)this.toIndex.get()) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " toIndex: " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex: " + fromIndex + " toIndex: " + toIndex);
        }
        return super.trimAsync(fromIndex, toIndex);
    }

    @Override
    public void trim(int fromIndex, int toIndex) {
        this.get(this.trimAsync(fromIndex, toIndex));
    }

    @Override
    public String toString() {
        Iterator it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            Object e;
            sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        Iterator e1 = this.iterator();
        Iterator e2 = ((List)o).iterator();
        while (e1.hasNext() && e2.hasNext()) {
            Object o1 = e1.next();
            Object o2 = e2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (Object e : this) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }
}

