/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RFuture;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.handler.CommandBatchEncoder;
import org.redisson.client.handler.CommandDecoder;
import org.redisson.client.handler.CommandEncoder;
import org.redisson.client.handler.CommandsQueue;
import org.redisson.client.handler.ConnectionWatchdog;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.misc.RedissonPromise;
import org.redisson.misc.URIBuilder;

public class RedisClient {
    private final Bootstrap bootstrap;
    private final InetSocketAddress addr;
    private final ChannelGroup channels = new DefaultChannelGroup(GlobalEventExecutor.INSTANCE);
    private ExecutorService executor;
    private final long commandTimeout;
    private Timer timer;
    private boolean hasOwnGroup;

    public RedisClient(String address) {
        this(URIBuilder.create(address));
    }

    public RedisClient(URI address) {
        this(new HashedWheelTimer(), Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2), new NioEventLoopGroup(), address);
        this.hasOwnGroup = true;
    }

    public RedisClient(Timer timer, ExecutorService executor, EventLoopGroup group, URI address) {
        this(timer, executor, group, address.getHost(), address.getPort());
    }

    public RedisClient(String host, int port) {
        this(new HashedWheelTimer(), Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2), new NioEventLoopGroup(), NioSocketChannel.class, host, port, 10000, 10000);
        this.hasOwnGroup = true;
    }

    public RedisClient(Timer timer, ExecutorService executor, EventLoopGroup group, String host, int port) {
        this(timer, executor, group, NioSocketChannel.class, host, port, 10000, 10000);
    }

    public RedisClient(String host, int port, int connectTimeout, int commandTimeout) {
        this(new HashedWheelTimer(), Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2), new NioEventLoopGroup(), NioSocketChannel.class, host, port, connectTimeout, commandTimeout);
    }

    public RedisClient(final Timer timer, ExecutorService executor, EventLoopGroup group, Class<? extends SocketChannel> socketChannelClass, String host, int port, int connectTimeout, int commandTimeout) {
        if (timer == null) {
            throw new NullPointerException("timer param can't be null");
        }
        this.executor = executor;
        this.timer = timer;
        this.addr = new InetSocketAddress(host, port);
        this.bootstrap = ((Bootstrap)((Bootstrap)new Bootstrap().channel(socketChannelClass)).group(group)).remoteAddress(this.addr);
        this.bootstrap.handler(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addFirst(new ConnectionWatchdog(RedisClient.this.bootstrap, RedisClient.this.channels, timer), CommandEncoder.INSTANCE, CommandBatchEncoder.INSTANCE, new CommandsQueue(), new CommandDecoder(RedisClient.this.executor));
            }
        });
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, connectTimeout);
        this.commandTimeout = commandTimeout;
    }

    public InetSocketAddress getAddr() {
        return this.addr;
    }

    public long getCommandTimeout() {
        return this.commandTimeout;
    }

    public Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    public RedisConnection connect() {
        try {
            ChannelFuture future = this.bootstrap.connect();
            future.syncUninterruptibly();
            return new RedisConnection(this, future.channel());
        }
        catch (Exception e) {
            throw new RedisConnectionException("Unable to connect to: " + this.addr, e);
        }
    }

    public RFuture<RedisConnection> connectAsync() {
        final RedissonPromise<RedisConnection> f = new RedissonPromise<RedisConnection>();
        ChannelFuture channelFuture = this.bootstrap.connect();
        channelFuture.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(final ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    final RedisConnection c = new RedisConnection(RedisClient.this, future.channel());
                    RedisClient.this.bootstrap.group().execute(new Runnable(){

                        @Override
                        public void run() {
                            if (!f.trySuccess(c)) {
                                c.closeAsync();
                            }
                        }
                    });
                } else {
                    RedisClient.this.bootstrap.group().execute(new Runnable(){

                        @Override
                        public void run() {
                            f.tryFailure(future.cause());
                        }
                    });
                }
            }
        });
        return f;
    }

    public RedisPubSubConnection connectPubSub() {
        try {
            ChannelFuture future = this.bootstrap.connect();
            future.syncUninterruptibly();
            return new RedisPubSubConnection(this, future.channel());
        }
        catch (Exception e) {
            throw new RedisConnectionException("Unable to connect to: " + this.addr, e);
        }
    }

    public RFuture<RedisPubSubConnection> connectPubSubAsync() {
        final RedissonPromise<RedisPubSubConnection> f = new RedissonPromise<RedisPubSubConnection>();
        ChannelFuture channelFuture = this.bootstrap.connect();
        channelFuture.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(final ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    final RedisPubSubConnection c = new RedisPubSubConnection(RedisClient.this, future.channel());
                    RedisClient.this.bootstrap.group().execute(new Runnable(){

                        @Override
                        public void run() {
                            if (!f.trySuccess(c)) {
                                c.closeAsync();
                            }
                        }
                    });
                } else {
                    RedisClient.this.bootstrap.group().execute(new Runnable(){

                        @Override
                        public void run() {
                            f.tryFailure(future.cause());
                        }
                    });
                }
            }
        });
        return f;
    }

    public void shutdown() {
        this.shutdownAsync().syncUninterruptibly();
        if (this.hasOwnGroup) {
            this.timer.stop();
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(15L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.bootstrap.group().shutdownGracefully();
        }
    }

    public ChannelGroupFuture shutdownAsync() {
        for (Channel channel : this.channels) {
            Object connection = RedisConnection.getFrom(channel);
            if (connection == null) continue;
            ((RedisConnection)connection).setClosed(true);
        }
        return this.channels.close();
    }

    public Map<String, String> serverInfo() {
        try {
            return (Map)this.serverInfoAsync().sync().get();
        }
        catch (Exception e) {
            throw new RedisConnectionException("Unable to retrieve server into from: " + this.addr, e);
        }
    }

    public RFuture<Map<String, String>> serverInfoAsync() {
        final RedisConnection connection = this.connect();
        RFuture<Map<String, String>> async = connection.async(RedisCommands.SERVER_INFO, new Object[0]);
        async.addListener(new FutureListener<Map<String, String>>(){

            @Override
            public void operationComplete(Future<Map<String, String>> future) throws Exception {
                connection.closeAsync();
            }
        });
        return async;
    }

    public String toString() {
        return "[addr=" + this.addr + "]";
    }
}

