/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation.set;

import org.redisson.RedissonSet;
import org.redisson.api.RObject;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.operation.set.SetOperation;

public class MoveOperation
extends SetOperation {
    private String destinationName;
    private Object value;

    public MoveOperation(RObject set, String destinationName, long threadId, Object value, String transactionId) {
        this(set.getName(), set.getCodec(), destinationName, threadId, value, transactionId);
    }

    public MoveOperation(String name, Codec codec, String destinationName, long threadId, Object value, String transactionId) {
        super(name, codec, transactionId, threadId);
        this.destinationName = destinationName;
        this.value = value;
    }

    @Override
    public void commit(CommandAsyncExecutor commandExecutor) {
        RedissonSet<Object> set = new RedissonSet<Object>(this.codec, commandExecutor, this.name, null);
        RedissonSet destinationSet = new RedissonSet(this.codec, commandExecutor, this.destinationName, null);
        set.moveAsync(destinationSet.getName(), this.value);
        this.getLock(destinationSet, commandExecutor, this.value).unlockAsync(this.threadId);
        this.getLock(set, commandExecutor, this.value).unlockAsync(this.threadId);
    }

    @Override
    public void rollback(CommandAsyncExecutor commandExecutor) {
        RedissonSet set = new RedissonSet(this.codec, commandExecutor, this.name, null);
        RedissonSet destinationSet = new RedissonSet(this.codec, commandExecutor, this.destinationName, null);
        this.getLock(destinationSet, commandExecutor, this.value).unlockAsync(this.threadId);
        this.getLock(set, commandExecutor, this.value).unlockAsync(this.threadId);
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public long getThreadId() {
        return this.threadId;
    }
}

