/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction;

import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.redisson.RedissonSetCache;
import org.redisson.ScanResult;
import org.redisson.api.RFuture;
import org.redisson.api.mapreduce.RCollectionMapReduce;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.TransactionalSetCache;
import org.redisson.transaction.operation.TransactionalOperation;

public class RedissonTransactionalSetCache<V>
extends RedissonSetCache<V> {
    private final TransactionalSetCache<V> transactionalSet;
    private final AtomicBoolean executed;

    public RedissonTransactionalSetCache(CommandAsyncExecutor commandExecutor, String name, List<TransactionalOperation> operations, long timeout, AtomicBoolean executed, String transactionId) {
        super(null, commandExecutor, name, null);
        this.executed = executed;
        RedissonSetCache innerSet = new RedissonSetCache(null, commandExecutor, name, null);
        this.transactionalSet = new TransactionalSetCache(commandExecutor, timeout, operations, innerSet, transactionId);
    }

    public RedissonTransactionalSetCache(Codec codec, CommandAsyncExecutor commandExecutor, String name, List<TransactionalOperation> operations, long timeout, AtomicBoolean executed, String transactionId) {
        super(null, commandExecutor, name, null);
        this.executed = executed;
        RedissonSetCache innerSet = new RedissonSetCache(codec, null, commandExecutor, name, null);
        this.transactionalSet = new TransactionalSetCache(commandExecutor, timeout, operations, innerSet, transactionId);
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit) {
        throw new UnsupportedOperationException("expire method is not supported in transaction");
    }

    @Override
    public RFuture<Boolean> expireAtAsync(Date timestamp) {
        throw new UnsupportedOperationException("expire method is not supported in transaction");
    }

    @Override
    public RFuture<Boolean> expireAsync(Instant timestamp) {
        throw new UnsupportedOperationException("expire method is not supported in transaction");
    }

    @Override
    public RFuture<Boolean> expireAtAsync(long timestamp) {
        throw new UnsupportedOperationException("expire method is not supported in transaction");
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        throw new UnsupportedOperationException("clearExpire method is not supported in transaction");
    }

    @Override
    public RFuture<Boolean> moveAsync(int database) {
        throw new UnsupportedOperationException("move method is not supported in transaction");
    }

    @Override
    public RFuture<Void> migrateAsync(String host, int port, int database, long timeout) {
        throw new UnsupportedOperationException("migrate method is not supported in transaction");
    }

    @Override
    public <KOut, VOut> RCollectionMapReduce<V, KOut, VOut> mapReduce() {
        throw new UnsupportedOperationException("mapReduce method is not supported in transaction");
    }

    @Override
    public ScanResult<Object> scanIterator(String name, RedisClient client, long startPos, String pattern, int count) {
        this.checkState();
        return this.transactionalSet.scanIterator(name, client, startPos, pattern, count);
    }

    @Override
    public RFuture<Boolean> containsAsync(Object o) {
        this.checkState();
        return this.transactionalSet.containsAsync(o);
    }

    @Override
    public RFuture<Set<V>> readAllAsync() {
        this.checkState();
        return this.transactionalSet.readAllAsync();
    }

    @Override
    public RFuture<Boolean> addAsync(V e) {
        this.checkState();
        return this.transactionalSet.addAsync(e);
    }

    @Override
    public RFuture<Boolean> addAsync(V value, long ttl, TimeUnit unit) {
        this.checkState();
        return this.transactionalSet.addAsync(value, ttl, unit);
    }

    @Override
    public RFuture<Boolean> removeAsync(Object o) {
        this.checkState();
        return this.transactionalSet.removeAsync(o);
    }

    @Override
    public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
        this.checkState();
        return this.transactionalSet.addAllAsync(c);
    }

    @Override
    public RFuture<Boolean> retainAllAsync(Collection<?> c) {
        this.checkState();
        return this.transactionalSet.retainAllAsync(c);
    }

    @Override
    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        this.checkState();
        return this.transactionalSet.removeAllAsync(c);
    }

    protected void checkState() {
        if (this.executed.get()) {
            throw new IllegalStateException("Unable to execute operation. Transaction is in finished state!");
        }
    }
}

