/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import java.lang.reflect.Field;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.redisson.api.RFuture;
import org.redisson.misc.RPromise;

public class RedissonPromise<T>
extends CompletableFuture<T>
implements RPromise<T> {
    private static final Field LISTENERS_FIELD;
    private final Promise<T> promise = ImmediateEventExecutor.INSTANCE.newPromise();

    public static <V> RFuture<V> newFailedFuture(Throwable cause) {
        RedissonPromise future = new RedissonPromise();
        future.tryFailure(cause);
        return future;
    }

    public static <V> RFuture<V> newSucceededFuture(V result) {
        RedissonPromise<V> future = new RedissonPromise<V>();
        future.trySuccess(result);
        return future;
    }

    @Override
    public boolean isSuccess() {
        return this.promise.isSuccess();
    }

    @Override
    public boolean isDone() {
        return this.promise.isDone();
    }

    @Override
    public boolean isCancelled() {
        return this.promise.isCancelled();
    }

    @Override
    public boolean trySuccess(T result) {
        if (this.promise.trySuccess(result)) {
            this.complete(result);
            return true;
        }
        return false;
    }

    @Override
    public Throwable cause() {
        return this.promise.cause();
    }

    @Override
    public boolean tryFailure(Throwable cause) {
        if (this.promise.tryFailure(cause)) {
            this.completeExceptionally(cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean setUncancellable() {
        return this.promise.setUncancellable();
    }

    @Override
    public RPromise<T> await() throws InterruptedException {
        this.promise.await();
        return this;
    }

    @Override
    public RPromise<T> awaitUninterruptibly() {
        this.promise.awaitUninterruptibly();
        return this;
    }

    @Override
    public RPromise<T> sync() throws InterruptedException {
        this.promise.sync();
        return this;
    }

    @Override
    public RPromise<T> syncUninterruptibly() {
        this.promise.syncUninterruptibly();
        return this;
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.promise.await(timeout, unit);
    }

    @Override
    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.promise.await(timeoutMillis);
    }

    @Override
    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        return this.promise.awaitUninterruptibly(timeout, unit);
    }

    @Override
    public boolean awaitUninterruptibly(long timeoutMillis) {
        return this.promise.awaitUninterruptibly(timeoutMillis);
    }

    @Override
    public T getNow() {
        return (T)this.promise.getNow();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.promise.cancel(mayInterruptIfRunning)) {
            return super.cancel(mayInterruptIfRunning);
        }
        return false;
    }

    @Override
    public boolean hasListeners() {
        try {
            return LISTENERS_FIELD.get(this.promise) != null || this.getNumberOfDependents() > 0;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String toString() {
        return "RedissonPromise [promise=" + this.promise + "]";
    }

    @Override
    public void onComplete(BiConsumer<? super T, ? super Throwable> action) {
        this.promise.addListener(f -> {
            if (!f.isSuccess()) {
                action.accept(null, f.cause());
                return;
            }
            action.accept((Object)f.getNow(), (Throwable)null);
        });
    }

    static {
        try {
            LISTENERS_FIELD = DefaultPromise.class.getDeclaredField("listeners");
            LISTENERS_FIELD.setAccessible(true);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

