/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection.balancer;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.balancer.LoadBalancer;
import org.redisson.misc.RedisURI;

public class WeightedRoundRobinBalancer
implements LoadBalancer {
    private final AtomicInteger index = new AtomicInteger(-1);
    private final Map<InetSocketAddress, WeightEntry> weights = new ConcurrentHashMap<InetSocketAddress, WeightEntry>();
    private final int defaultWeight;

    public WeightedRoundRobinBalancer(Map<String, Integer> weights, int defaultWeight) {
        for (Map.Entry<String, Integer> entry : weights.entrySet()) {
            RedisURI uri = new RedisURI(entry.getKey());
            InetSocketAddress addr = new InetSocketAddress(uri.getHost(), uri.getPort());
            if (entry.getValue() <= 0) {
                throw new IllegalArgumentException("Weight can't be less than or equal zero");
            }
            this.weights.put(addr, new WeightEntry(entry.getValue()));
        }
        if (defaultWeight <= 0) {
            throw new IllegalArgumentException("Weight can't be less than or equal zero");
        }
        this.defaultWeight = defaultWeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientConnectionsEntry getEntry(List<ClientConnectionsEntry> clients) {
        clients.stream().map(e -> e.getClient().getAddr()).distinct().filter(a -> !this.weights.containsKey(a)).forEach(a -> this.weights.put((InetSocketAddress)a, new WeightEntry(this.defaultWeight)));
        Map<InetSocketAddress, WeightEntry> weightsCopy = new HashMap<InetSocketAddress, WeightEntry>(this.weights);
        WeightedRoundRobinBalancer weightedRoundRobinBalancer = this;
        synchronized (weightedRoundRobinBalancer) {
            List<ClientConnectionsEntry> clientsCopy;
            weightsCopy.values().removeIf(WeightEntry::isWeightCounterZero);
            if (weightsCopy.isEmpty()) {
                for (WeightEntry weightEntry : this.weights.values()) {
                    weightEntry.resetWeightCounter();
                }
                weightsCopy = this.weights;
            }
            if ((clientsCopy = this.findClients(clients, weightsCopy)).isEmpty()) {
                for (WeightEntry weightEntry : this.weights.values()) {
                    weightEntry.resetWeightCounter();
                }
                weightsCopy = this.weights;
                clientsCopy = this.findClients(clients, weightsCopy);
            }
            int n = Math.abs(this.index.incrementAndGet() % clientsCopy.size());
            ClientConnectionsEntry clientConnectionsEntry = clientsCopy.get(n);
            WeightEntry weightEntry = this.weights.get(clientConnectionsEntry.getClient().getAddr());
            weightEntry.decWeightCounter();
            return clientConnectionsEntry;
        }
    }

    private List<ClientConnectionsEntry> findClients(List<ClientConnectionsEntry> clients, Map<InetSocketAddress, WeightEntry> weightsCopy) {
        return clients.stream().filter(e -> weightsCopy.containsKey(e.getClient().getAddr())).collect(Collectors.toList());
    }

    static class WeightEntry {
        final int weight;
        int weightCounter;

        WeightEntry(int weight) {
            this.weight = weight;
            this.weightCounter = weight;
        }

        public boolean isWeightCounterZero() {
            return this.weightCounter == 0;
        }

        public void decWeightCounter() {
            --this.weightCounter;
        }

        public void resetWeightCounter() {
            this.weightCounter = this.weight;
        }
    }
}

