/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.redisson.client.ChannelName;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.client.protocol.pubsub.PubSubMessage;
import org.redisson.client.protocol.pubsub.PubSubMessageDecoder;
import org.redisson.client.protocol.pubsub.PubSubPatternMessage;
import org.redisson.client.protocol.pubsub.PubSubPatternMessageDecoder;
import org.redisson.client.protocol.pubsub.PubSubStatusMessage;
import org.redisson.client.protocol.pubsub.PubSubType;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;

public class RedisPubSubConnection
extends RedisConnection {
    final Queue<RedisPubSubListener<Object>> listeners = new ConcurrentLinkedQueue<RedisPubSubListener<Object>>();
    final Map<ChannelName, Codec> channels = new ConcurrentHashMap<ChannelName, Codec>();
    final Map<ChannelName, Codec> patternChannels = new ConcurrentHashMap<ChannelName, Codec>();
    final Set<ChannelName> unsubscibedChannels = new HashSet<ChannelName>();
    final Set<ChannelName> punsubscibedChannels = new HashSet<ChannelName>();

    public RedisPubSubConnection(RedisClient redisClient, Channel channel, RPromise<RedisPubSubConnection> connectionPromise) {
        super(redisClient, channel, connectionPromise);
    }

    public void addListener(RedisPubSubListener<?> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(RedisPubSubListener<?> listener) {
        this.listeners.remove(listener);
    }

    public void onMessage(PubSubStatusMessage message) {
        for (RedisPubSubListener redisPubSubListener : this.listeners) {
            redisPubSubListener.onStatus(message.getType(), message.getChannel());
        }
    }

    public void onMessage(PubSubMessage message) {
        for (RedisPubSubListener redisPubSubListener : this.listeners) {
            redisPubSubListener.onMessage(message.getChannel(), message.getValue());
        }
    }

    public void onMessage(PubSubPatternMessage message) {
        for (RedisPubSubListener redisPubSubListener : this.listeners) {
            redisPubSubListener.onPatternMessage(message.getPattern(), message.getChannel(), message.getValue());
        }
    }

    public ChannelFuture subscribe(Codec codec, ChannelName ... channels) {
        for (ChannelName ch : channels) {
            this.channels.put(ch, codec);
        }
        return this.async(new PubSubMessageDecoder(codec.getValueDecoder()), RedisCommands.SUBSCRIBE, (Object[])channels);
    }

    public ChannelFuture psubscribe(Codec codec, ChannelName ... channels) {
        for (ChannelName ch : channels) {
            this.patternChannels.put(ch, codec);
        }
        return this.async(new PubSubPatternMessageDecoder(codec.getValueDecoder()), RedisCommands.PSUBSCRIBE, (Object[])channels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture unsubscribe(final ChannelName ... channels) {
        RedisPubSubConnection redisPubSubConnection = this;
        synchronized (redisPubSubConnection) {
            for (ChannelName ch : channels) {
                this.channels.remove(ch);
                this.unsubscibedChannels.add(ch);
            }
        }
        ChannelFuture future = this.async((MultiDecoder<Object>)null, RedisCommands.UNSUBSCRIBE, (Object[])channels);
        future.addListener((GenericFutureListener<? extends Future<? super Void>>)new FutureListener<Void>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess()) {
                    for (ChannelName channel : channels) {
                        RedisPubSubConnection.this.removeDisconnectListener(channel);
                        RedisPubSubConnection.this.onMessage(new PubSubStatusMessage(PubSubType.UNSUBSCRIBE, channel));
                    }
                }
            }
        });
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDisconnectListener(ChannelName channel) {
        RedisPubSubConnection redisPubSubConnection = this;
        synchronized (redisPubSubConnection) {
            this.unsubscibedChannels.remove(channel);
            this.punsubscibedChannels.remove(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireDisconnected() {
        super.fireDisconnected();
        HashSet<ChannelName> channels = new HashSet<ChannelName>();
        HashSet<ChannelName> pchannels = new HashSet<ChannelName>();
        Iterator iterator = this;
        synchronized (iterator) {
            channels.addAll(this.unsubscibedChannels);
            pchannels.addAll(this.punsubscibedChannels);
        }
        for (ChannelName channel : channels) {
            this.onMessage(new PubSubStatusMessage(PubSubType.UNSUBSCRIBE, channel));
        }
        for (ChannelName channel : pchannels) {
            this.onMessage(new PubSubStatusMessage(PubSubType.PUNSUBSCRIBE, channel));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture punsubscribe(final ChannelName ... channels) {
        RedisPubSubConnection redisPubSubConnection = this;
        synchronized (redisPubSubConnection) {
            for (ChannelName ch : channels) {
                this.patternChannels.remove(ch);
                this.punsubscibedChannels.add(ch);
            }
        }
        ChannelFuture future = this.async((MultiDecoder<Object>)null, RedisCommands.PUNSUBSCRIBE, (Object[])channels);
        future.addListener((GenericFutureListener<? extends Future<? super Void>>)new FutureListener<Void>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess()) {
                    for (ChannelName channel : channels) {
                        RedisPubSubConnection.this.removeDisconnectListener(channel);
                        RedisPubSubConnection.this.onMessage(new PubSubStatusMessage(PubSubType.PUNSUBSCRIBE, channel));
                    }
                }
            }
        });
        return future;
    }

    private <T, R> ChannelFuture async(MultiDecoder<Object> messageDecoder, RedisCommand<T> command, Object ... params) {
        RedissonPromise promise = new RedissonPromise();
        return this.channel.writeAndFlush(new CommandData(promise, messageDecoder, null, command, params));
    }

    public Map<ChannelName, Codec> getChannels() {
        return Collections.unmodifiableMap(this.channels);
    }

    public Map<ChannelName, Codec> getPatternChannels() {
        return Collections.unmodifiableMap(this.patternChannels);
    }
}

