/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api;

import java.util.concurrent.TimeUnit;

public final class TransactionOptions {
    private long responseTimeout = 3000L;
    private int retryAttempts = 3;
    private long retryInterval = 1500L;
    private long syncTimeout = 5000L;
    private long timeout = 5000L;

    private TransactionOptions() {
    }

    public static TransactionOptions defaults() {
        return new TransactionOptions();
    }

    public long getResponseTimeout() {
        return this.responseTimeout;
    }

    public TransactionOptions responseTimeout(long timeout, TimeUnit unit) {
        this.responseTimeout = unit.toMillis(timeout);
        return this;
    }

    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    public TransactionOptions retryAttempts(int retryAttempts) {
        this.retryAttempts = retryAttempts;
        return this;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public TransactionOptions retryInterval(long retryInterval, TimeUnit retryIntervalUnit) {
        this.retryInterval = retryIntervalUnit.toMillis(retryInterval);
        return this;
    }

    public TransactionOptions syncSlavesTimeout(long syncTimeout, TimeUnit syncUnit) {
        this.syncTimeout = syncUnit.toMillis(syncTimeout);
        return this;
    }

    public long getSyncTimeout() {
        return this.syncTimeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public TransactionOptions timeout(long timeout, TimeUnit timeoutUnit) {
        if (timeout == -1L) {
            this.timeout = timeout;
            return this;
        }
        this.timeout = timeoutUnit.toMillis(timeout);
        return this;
    }
}

