/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonPatternTopic;
import org.redisson.RedissonSubList;
import org.redisson.api.ObjectListener;
import org.redisson.api.RFuture;
import org.redisson.api.RList;
import org.redisson.api.RedissonClient;
import org.redisson.api.SortOrder;
import org.redisson.api.listener.ListAddListener;
import org.redisson.api.listener.ListInsertListener;
import org.redisson.api.listener.ListRemoveListener;
import org.redisson.api.listener.ListSetListener;
import org.redisson.api.listener.ListTrimListener;
import org.redisson.api.mapreduce.RCollectionMapReduce;
import org.redisson.client.RedisException;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.BooleanNumberReplayConvertor;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.client.protocol.convertor.IntegerReplayConvertor;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.iterator.RedissonListIterator;
import org.redisson.mapreduce.RedissonCollectionMapReduce;
import org.redisson.misc.CountableListener;
import org.redisson.misc.RedissonPromise;

public class RedissonList<V>
extends RedissonExpirable
implements RList<V> {
    private RedissonClient redisson;

    public RedissonList(CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(commandExecutor, name);
        this.redisson = redisson;
    }

    public RedissonList(Codec codec, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(codec, commandExecutor, name);
        this.redisson = redisson;
    }

    @Override
    public <KOut, VOut> RCollectionMapReduce<V, KOut, VOut> mapReduce() {
        return new RedissonCollectionMapReduce(this, this.redisson, this.commandExecutor);
    }

    @Override
    public int size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public RFuture<Integer> sizeAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.LLEN_INT, this.getRawName());
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.get(this.containsAsync(o));
    }

    @Override
    public Iterator<V> iterator() {
        return this.listIterator();
    }

    @Override
    public Object[] toArray() {
        List<V> list = this.readAll();
        return list.toArray();
    }

    @Override
    public List<V> readAll() {
        return this.get(this.readAllAsync());
    }

    @Override
    public RFuture<List<V>> readAllAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.LRANGE, this.getRawName(), 0, -1);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        List<V> list = this.readAll();
        return list.toArray(a);
    }

    @Override
    public boolean add(V e) {
        return this.get(this.addAsync(e));
    }

    @Override
    public RFuture<Boolean> addAsync(V e) {
        return this.addAsync(e, RedisCommands.RPUSH_BOOLEAN);
    }

    protected <T> RFuture<T> addAsync(V e, RedisCommand<T> command) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, command, this.getRawName(), this.encode((Object)e));
    }

    @Override
    public boolean remove(Object o) {
        return this.get(this.removeAsync(o));
    }

    @Override
    public RFuture<Boolean> removeAsync(Object o) {
        return this.removeAsync(o, 1);
    }

    @Override
    public RFuture<Boolean> removeAsync(Object o, int count) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.LREM_SINGLE, this.getRawName(), count, this.encode(o));
    }

    @Override
    public boolean remove(Object o, int count) {
        return this.get(this.removeAsync(o, count));
    }

    @Override
    public RFuture<Boolean> containsAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return RedissonPromise.newSucceededFuture(true);
        }
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local items = redis.call('lrange', KEYS[1], 0, -1) for i=1, #items do for j = 1, #ARGV, 1 do if items[i] == ARGV[j] then table.remove(ARGV, j) end end end return #ARGV == 0 and 1 or 0", Collections.singletonList(this.getRawName()), this.encode(c).toArray());
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.get(this.containsAllAsync(c));
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        return this.get(this.addAllAsync(c));
    }

    @Override
    public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return RedissonPromise.newSucceededFuture(false);
        }
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 1);
        args.add(this.getRawName());
        this.encode(args, c);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.RPUSH_BOOLEAN, args.toArray());
    }

    @Override
    public RFuture<Boolean> addAllAsync(int index, Collection<? extends V> coll) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        if (coll.isEmpty()) {
            return RedissonPromise.newSucceededFuture(false);
        }
        if (index == 0) {
            ArrayList<Object> elements = new ArrayList<Object>();
            this.encode(elements, coll);
            Collections.reverse(elements);
            elements.add(0, this.getRawName());
            return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.LPUSH_BOOLEAN, elements.toArray());
        }
        ArrayList<Object> args = new ArrayList<Object>(coll.size() + 1);
        args.add(index);
        this.encode(args, coll);
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local ind = table.remove(ARGV, 1); local size = redis.call('llen', KEYS[1]); assert(tonumber(ind) <= size, 'index: ' .. ind .. ' but current size: ' .. size); local tail = redis.call('lrange', KEYS[1], ind, -1); redis.call('ltrim', KEYS[1], 0, ind - 1); for i=1, #ARGV, 5000 do redis.call('rpush', KEYS[1], unpack(ARGV, i, math.min(i+4999, #ARGV))); end if #tail > 0 then for i=1, #tail, 5000 do redis.call('rpush', KEYS[1], unpack(tail, i, math.min(i+4999, #tail))); end end;return 1;", Collections.singletonList(this.getRawName()), args.toArray());
    }

    @Override
    public boolean addAll(int index, Collection<? extends V> coll) {
        return this.get(this.addAllAsync(index, coll));
    }

    @Override
    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return RedissonPromise.newSucceededFuture(false);
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local v = 0 for i = 1, #ARGV, 1 do if redis.call('lrem', KEYS[1], 0, ARGV[i]) == 1 then v = 1 end end return v ", Collections.singletonList(this.getRawName()), this.encode(c).toArray());
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.get(this.removeAllAsync(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.get(this.retainAllAsync(c));
    }

    @Override
    public RFuture<Boolean> retainAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return this.deleteAsync();
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local changed = 0 local items = redis.call('lrange', KEYS[1], 0, -1) local i = 1 while i <= #items do local element = items[i] local isInAgrs = false for j = 1, #ARGV, 1 do if ARGV[j] == element then isInAgrs = true break end end if isInAgrs == false then redis.call('LREM', KEYS[1], 0, element) changed = 1 end i = i + 1 end return changed ", Collections.singletonList(this.getRawName()), this.encode(c).toArray());
    }

    @Override
    public void clear() {
        this.delete();
    }

    @Override
    public RFuture<V> getAsync(int index) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.LINDEX, this.getRawName(), index);
    }

    @Override
    public List<V> get(int ... indexes) {
        return this.get(this.getAsync(indexes));
    }

    @Override
    public RFuture<List<V>> getAsync(int ... indexes) {
        ArrayList<Integer> params = new ArrayList<Integer>();
        int[] nArray = indexes;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer index = nArray[i];
            params.add(index);
        }
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, RedisCommands.EVAL_LIST, "local result = {}; for i = 1, #ARGV, 1 do local value = redis.call('lindex', KEYS[1], ARGV[i]);table.insert(result, value);end; return result;", Collections.singletonList(this.getRawName()), params.toArray());
    }

    @Override
    public V get(int index) {
        return this.getValue(index);
    }

    V getValue(int index) {
        return this.get(this.getAsync(index));
    }

    @Override
    public V set(int index, V element) {
        try {
            return this.get(this.setAsync(index, element));
        }
        catch (RedisException e) {
            if (e.getCause() instanceof IndexOutOfBoundsException) {
                throw (IndexOutOfBoundsException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public RFuture<V> setAsync(int index, V element) {
        RedissonPromise result = new RedissonPromise();
        RFuture future = this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_OBJECT, "local v = redis.call('lindex', KEYS[1], ARGV[1]); redis.call('lset', KEYS[1], ARGV[1], ARGV[2]); return v", Collections.singletonList(this.getRawName()), index, this.encode((Object)element));
        future.onComplete((res, e) -> {
            if (e != null) {
                if (e.getMessage().contains("ERR index out of range")) {
                    result.tryFailure(new IndexOutOfBoundsException("index out of range"));
                    return;
                }
                result.tryFailure((Throwable)e);
                return;
            }
            result.trySuccess(res);
        });
        return result;
    }

    @Override
    public void fastSet(int index, V element) {
        this.get(this.fastSetAsync(index, element));
    }

    @Override
    public RFuture<Void> fastSetAsync(int index, V element) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.LSET, this.getRawName(), index, this.encode((Object)element));
    }

    @Override
    public void add(int index, V element) {
        this.addAll(index, (Collection<? extends V>)Collections.singleton(element));
    }

    @Override
    public RFuture<Boolean> addAsync(int index, V element) {
        return this.addAllAsync(index, Collections.singleton(element));
    }

    @Override
    public V remove(int index) {
        return this.get(this.removeAsync(index));
    }

    @Override
    public RFuture<V> removeAsync(int index) {
        if (index == 0) {
            return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.LPOP, this.getRawName());
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_OBJECT, "local v = redis.call('lindex', KEYS[1], ARGV[1]); redis.call('lset', KEYS[1], ARGV[1], 'DELETED_BY_REDISSON');redis.call('lrem', KEYS[1], 1, 'DELETED_BY_REDISSON');return v", Collections.singletonList(this.getRawName()), index);
    }

    @Override
    public void fastRemove(int index) {
        this.get(this.fastRemoveAsync(index));
    }

    @Override
    public RFuture<Void> fastRemoveAsync(int index) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_VOID, "redis.call('lset', KEYS[1], ARGV[1], 'DELETED_BY_REDISSON');redis.call('lrem', KEYS[1], 1, 'DELETED_BY_REDISSON');", Collections.singletonList(this.getRawName()), index);
    }

    @Override
    public int indexOf(Object o) {
        return this.get(this.indexOfAsync(o));
    }

    @Override
    public RFuture<Boolean> containsAsync(Object o) {
        return this.indexOfAsync(o, new BooleanNumberReplayConvertor(-1L));
    }

    public <R> RFuture<R> indexOfAsync(Object o, Convertor<R> convertor) {
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, new RedisCommand<R>("EVAL", convertor), "local key = KEYS[1] local obj = ARGV[1] local items = redis.call('lrange', key, 0, -1) for i=1,#items do if items[i] == obj then return i - 1 end end return -1", Collections.singletonList(this.getRawName()), this.encode(o));
    }

    @Override
    public RFuture<Integer> indexOfAsync(Object o) {
        return this.indexOfAsync(o, new IntegerReplayConvertor());
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.get(this.lastIndexOfAsync(o));
    }

    @Override
    public RFuture<Integer> lastIndexOfAsync(Object o) {
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, RedisCommands.EVAL_INTEGER, "local key = KEYS[1] local obj = ARGV[1] local items = redis.call('lrange', key, 0, -1) for i = #items, 1, -1 do if items[i] == obj then return i - 1 end end return -1", Collections.singletonList(this.getRawName()), this.encode(o));
    }

    public <R> RFuture<R> lastIndexOfAsync(Object o, Convertor<R> convertor) {
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, new RedisCommand<R>("EVAL", convertor), "local key = KEYS[1] local obj = ARGV[1] local items = redis.call('lrange', key, 0, -1) for i = #items, 1, -1 do if items[i] == obj then return i - 1 end end return -1", Collections.singletonList(this.getRawName()), this.encode(o));
    }

    @Override
    public void trim(int fromIndex, int toIndex) {
        this.get(this.trimAsync(fromIndex, toIndex));
    }

    @Override
    public RFuture<Void> trimAsync(int fromIndex, int toIndex) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.LTRIM, this.getRawName(), fromIndex, toIndex);
    }

    @Override
    public ListIterator<V> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<V> listIterator(int ind) {
        return new RedissonListIterator<V>(ind){

            @Override
            public V getValue(int index) {
                return RedissonList.this.getValue(index);
            }

            @Override
            public V remove(int index) {
                return RedissonList.this.remove(index);
            }

            @Override
            public void fastSet(int index, V value) {
                RedissonList.this.fastSet(index, value);
            }

            @Override
            public void add(int index, V value) {
                RedissonList.this.add(index, value);
            }
        };
    }

    @Override
    public RList<V> subList(int fromIndex, int toIndex) {
        int size = this.size();
        if (fromIndex < 0 || toIndex > size) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " toIndex: " + toIndex + " size: " + size);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex: " + fromIndex + " toIndex: " + toIndex);
        }
        return new RedissonSubList(this.codec, this.commandExecutor, this.getRawName(), fromIndex, toIndex);
    }

    public String toString() {
        Iterator<V> it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            V e;
            sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        Iterator<V> e1 = this.iterator();
        Iterator e2 = ((List)o).iterator();
        while (e1.hasNext() && e2.hasNext()) {
            V o1 = e1.next();
            Object o2 = e2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (V e : this) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    @Override
    public RFuture<Integer> addAfterAsync(V elementToFind, V element) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.LINSERT_INT, this.getRawName(), "AFTER", this.encode((Object)elementToFind), this.encode((Object)element));
    }

    @Override
    public RFuture<Integer> addBeforeAsync(V elementToFind, V element) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.LINSERT_INT, this.getRawName(), "BEFORE", this.encode((Object)elementToFind), this.encode((Object)element));
    }

    @Override
    public int addAfter(V elementToFind, V element) {
        return this.get(this.addAfterAsync(elementToFind, element));
    }

    @Override
    public int addBefore(V elementToFind, V element) {
        return this.get(this.addBeforeAsync(elementToFind, element));
    }

    @Override
    public List<V> readSort(SortOrder order) {
        return this.get(this.readSortAsync(order));
    }

    @Override
    public RFuture<List<V>> readSortAsync(SortOrder order) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SORT_LIST, new Object[]{this.getRawName(), order});
    }

    @Override
    public List<V> readSort(SortOrder order, int offset, int count) {
        return this.get(this.readSortAsync(order, offset, count));
    }

    @Override
    public RFuture<List<V>> readSortAsync(SortOrder order, int offset, int count) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SORT_LIST, new Object[]{this.getRawName(), "LIMIT", offset, count, order});
    }

    @Override
    public List<V> readSort(String byPattern, SortOrder order) {
        return this.get(this.readSortAsync(byPattern, order));
    }

    @Override
    public RFuture<List<V>> readSortAsync(String byPattern, SortOrder order) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SORT_LIST, new Object[]{this.getRawName(), "BY", byPattern, order});
    }

    @Override
    public List<V> readSort(String byPattern, SortOrder order, int offset, int count) {
        return this.get(this.readSortAsync(byPattern, order, offset, count));
    }

    @Override
    public RFuture<List<V>> readSortAsync(String byPattern, SortOrder order, int offset, int count) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SORT_LIST, new Object[]{this.getRawName(), "BY", byPattern, "LIMIT", offset, count, order});
    }

    @Override
    public <T> Collection<T> readSort(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.get(this.readSortAsync(byPattern, getPatterns, order));
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.readSortAsync(byPattern, getPatterns, order, -1, -1);
    }

    @Override
    public <T> Collection<T> readSort(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.get(this.readSortAsync(byPattern, getPatterns, order, offset, count));
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.readSortAsync(byPattern, getPatterns, order, offset, count, false);
    }

    @Override
    public List<V> readSortAlpha(SortOrder order) {
        return this.get(this.readSortAlphaAsync(order));
    }

    @Override
    public RFuture<List<V>> readSortAlphaAsync(SortOrder order) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SORT_LIST, new Object[]{this.getRawName(), "ALPHA", order});
    }

    @Override
    public List<V> readSortAlpha(SortOrder order, int offset, int count) {
        return this.get(this.readSortAlphaAsync(order, offset, count));
    }

    @Override
    public RFuture<List<V>> readSortAlphaAsync(SortOrder order, int offset, int count) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SORT_LIST, new Object[]{this.getRawName(), "LIMIT", offset, count, "ALPHA", order});
    }

    @Override
    public List<V> readSortAlpha(String byPattern, SortOrder order) {
        return this.get(this.readSortAlphaAsync(byPattern, order));
    }

    @Override
    public RFuture<List<V>> readSortAlphaAsync(String byPattern, SortOrder order) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SORT_LIST, new Object[]{this.getRawName(), "BY", byPattern, "ALPHA", order});
    }

    @Override
    public List<V> readSortAlpha(String byPattern, SortOrder order, int offset, int count) {
        return this.get(this.readSortAlphaAsync(byPattern, order, offset, count));
    }

    @Override
    public RFuture<List<V>> readSortAlphaAsync(String byPattern, SortOrder order, int offset, int count) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SORT_LIST, new Object[]{this.getRawName(), "BY", byPattern, "LIMIT", offset, count, "ALPHA", order});
    }

    @Override
    public <T> Collection<T> readSortAlpha(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.get(this.readSortAlphaAsync(byPattern, getPatterns, order));
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAlphaAsync(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.readSortAlphaAsync(byPattern, getPatterns, order, -1, -1);
    }

    @Override
    public <T> Collection<T> readSortAlpha(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.get(this.readSortAlphaAsync(byPattern, getPatterns, order, offset, count));
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAlphaAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.readSortAsync(byPattern, getPatterns, order, offset, count, true);
    }

    @Override
    public int sortTo(String destName, SortOrder order) {
        return this.get(this.sortToAsync(destName, order));
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, SortOrder order) {
        return this.sortToAsync(destName, null, Collections.emptyList(), order, -1, -1);
    }

    @Override
    public int sortTo(String destName, SortOrder order, int offset, int count) {
        return this.get(this.sortToAsync(destName, order, offset, count));
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, SortOrder order, int offset, int count) {
        return this.sortToAsync(destName, null, Collections.emptyList(), order, offset, count);
    }

    @Override
    public int sortTo(String destName, String byPattern, SortOrder order, int offset, int count) {
        return this.get(this.sortToAsync(destName, byPattern, order, offset, count));
    }

    @Override
    public int sortTo(String destName, String byPattern, SortOrder order) {
        return this.get(this.sortToAsync(destName, byPattern, order));
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, SortOrder order) {
        return this.sortToAsync(destName, byPattern, Collections.emptyList(), order, -1, -1);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, SortOrder order, int offset, int count) {
        return this.sortToAsync(destName, byPattern, Collections.emptyList(), order, offset, count);
    }

    @Override
    public int sortTo(String destName, String byPattern, List<String> getPatterns, SortOrder order) {
        return this.get(this.sortToAsync(destName, byPattern, getPatterns, order));
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order) {
        return this.sortToAsync(destName, byPattern, getPatterns, order, -1, -1);
    }

    @Override
    public int sortTo(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.get(this.sortToAsync(destName, byPattern, getPatterns, order, offset, count));
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getRawName());
        if (byPattern != null) {
            params.add("BY");
            params.add(byPattern);
        }
        if (offset != -1 && count != -1) {
            params.add("LIMIT");
        }
        if (offset != -1) {
            params.add(offset);
        }
        if (count != -1) {
            params.add(count);
        }
        for (String pattern : getPatterns) {
            params.add("GET");
            params.add(pattern);
        }
        params.add((Object)order);
        params.add("STORE");
        params.add(destName);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SORT_TO, params.toArray());
    }

    private <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count, boolean alpha) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getRawName());
        if (byPattern != null) {
            params.add("BY");
            params.add(byPattern);
        }
        if (offset != -1 && count != -1) {
            params.add("LIMIT");
        }
        if (offset != -1) {
            params.add(offset);
        }
        if (count != -1) {
            params.add(count);
        }
        if (getPatterns != null) {
            for (String pattern : getPatterns) {
                params.add("GET");
                params.add(pattern);
            }
        }
        if (alpha) {
            params.add("ALPHA");
        }
        if (order != null) {
            params.add((Object)order);
        }
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SORT_LIST, params.toArray());
    }

    @Override
    public RFuture<List<V>> rangeAsync(int toIndex) {
        return this.rangeAsync(0, toIndex);
    }

    @Override
    public RFuture<List<V>> rangeAsync(int fromIndex, int toIndex) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.LRANGE, this.getRawName(), fromIndex, toIndex);
    }

    @Override
    public List<V> range(int toIndex) {
        return this.get(this.rangeAsync(toIndex));
    }

    @Override
    public List<V> range(int fromIndex, int toIndex) {
        return this.get(this.rangeAsync(fromIndex, toIndex));
    }

    @Override
    public int addListener(ObjectListener listener) {
        if (listener instanceof ListAddListener) {
            return this.addListener("__keyevent@*:rpush", (ListAddListener)listener, ListAddListener::onListAdd);
        }
        if (listener instanceof ListRemoveListener) {
            return this.addListener("__keyevent@*:lrem", (ListRemoveListener)listener, ListRemoveListener::onListRemove);
        }
        if (listener instanceof ListTrimListener) {
            return this.addListener("__keyevent@*:ltrim", (ListTrimListener)listener, ListTrimListener::onListTrim);
        }
        if (listener instanceof ListSetListener) {
            return this.addListener("__keyevent@*:lset", (ListSetListener)listener, ListSetListener::onListSet);
        }
        if (listener instanceof ListInsertListener) {
            return this.addListener("__keyevent@*:linsert", (ListInsertListener)listener, ListInsertListener::onListInsert);
        }
        return super.addListener(listener);
    }

    @Override
    public RFuture<Integer> addListenerAsync(ObjectListener listener) {
        if (listener instanceof ListAddListener) {
            return this.addListenerAsync("__keyevent@*:rpush", (ListAddListener)listener, ListAddListener::onListAdd);
        }
        if (listener instanceof ListRemoveListener) {
            return this.addListenerAsync("__keyevent@*:lrem", (ListRemoveListener)listener, ListRemoveListener::onListRemove);
        }
        if (listener instanceof ListTrimListener) {
            return this.addListenerAsync("__keyevent@*:ltrim", (ListTrimListener)listener, ListTrimListener::onListTrim);
        }
        if (listener instanceof ListSetListener) {
            return this.addListenerAsync("__keyevent@*:lset", (ListSetListener)listener, ListSetListener::onListSet);
        }
        if (listener instanceof ListInsertListener) {
            return this.addListenerAsync("__keyevent@*:linsert", (ListInsertListener)listener, ListInsertListener::onListInsert);
        }
        return super.addListenerAsync(listener);
    }

    @Override
    public void removeListener(int listenerId) {
        RedissonPatternTopic addTopic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, "__keyevent@*:rpush");
        addTopic.removeListener(listenerId);
        RedissonPatternTopic remTopic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, "__keyevent@*:lrem");
        remTopic.removeListener(listenerId);
        RedissonPatternTopic trimTopic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, "__keyevent@*:ltrim");
        trimTopic.removeListener(listenerId);
        RedissonPatternTopic setTopic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, "__keyevent@*:lset");
        setTopic.removeListener(listenerId);
        RedissonPatternTopic insertTopic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, "__keyevent@*:linsert");
        insertTopic.removeListener(listenerId);
        super.removeListener(listenerId);
    }

    @Override
    public RFuture<Void> removeListenerAsync(int listenerId) {
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        CountableListener<Object> listener = new CountableListener<Object>(result, null, 5);
        RedissonPatternTopic addTopic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, "__keyevent@*:rpush");
        addTopic.removeListenerAsync(listenerId).onComplete(listener);
        RedissonPatternTopic remTopic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, "__keyevent@*:lrem");
        remTopic.removeListenerAsync(listenerId).onComplete(listener);
        RedissonPatternTopic trimTopic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, "__keyevent@*:ltrim");
        trimTopic.removeListenerAsync(listenerId).onComplete(listener);
        RedissonPatternTopic setTopic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, "__keyevent@*:lset");
        setTopic.removeListenerAsync(listenerId).onComplete(listener);
        RedissonPatternTopic insertTopic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, "__keyevent@*:linsert");
        insertTopic.removeListenerAsync(listenerId).onComplete(listener);
        this.removeListenersAsync(listenerId, listener);
        return result;
    }

    @Override
    public boolean removeIf(Predicate<? super V> filter) {
        throw new UnsupportedOperationException();
    }
}

