/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.redisson.RedissonExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RHyperLogLog;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonHyperLogLog<V>
extends RedissonExpirable
implements RHyperLogLog<V> {
    public RedissonHyperLogLog(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    public RedissonHyperLogLog(Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
    }

    @Override
    public boolean add(V obj) {
        return this.get(this.addAsync(obj));
    }

    @Override
    public boolean addAll(Collection<V> objects) {
        return this.get(this.addAllAsync(objects));
    }

    @Override
    public long count() {
        return this.get(this.countAsync());
    }

    @Override
    public long countWith(String ... otherLogNames) {
        return this.get(this.countWithAsync(otherLogNames));
    }

    @Override
    public void mergeWith(String ... otherLogNames) {
        this.get(this.mergeWithAsync(otherLogNames));
    }

    @Override
    public RFuture<Boolean> addAsync(V obj) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.PFADD, this.getRawName(), this.encode((Object)obj));
    }

    @Override
    public RFuture<Boolean> addAllAsync(Collection<V> objects) {
        ArrayList<Object> args = new ArrayList<Object>(objects.size() + 1);
        args.add(this.getRawName());
        this.encode(args, objects);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.PFADD, args.toArray());
    }

    @Override
    public RFuture<Long> countAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.PFCOUNT, this.getRawName());
    }

    @Override
    public RFuture<Long> countWithAsync(String ... otherLogNames) {
        ArrayList<String> args = new ArrayList<String>(otherLogNames.length + 1);
        args.add(this.getRawName());
        args.addAll(Arrays.asList(otherLogNames));
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.PFCOUNT, args.toArray());
    }

    @Override
    public RFuture<Void> mergeWithAsync(String ... otherLogNames) {
        ArrayList<String> args = new ArrayList<String>(otherLogNames.length + 1);
        args.add(this.getRawName());
        args.addAll(Arrays.asList(otherLogNames));
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.PFMERGE, args.toArray());
    }
}

