/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.RedissonCountDownLatchEntry;
import org.redisson.RedissonObject;
import org.redisson.api.RCountDownLatch;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.redisson.pubsub.CountDownLatchPubSub;

public class RedissonCountDownLatch
extends RedissonObject
implements RCountDownLatch {
    private final CountDownLatchPubSub pubSub;
    private final String id;

    protected RedissonCountDownLatch(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
        this.id = commandExecutor.getConnectionManager().getId();
        this.pubSub = commandExecutor.getConnectionManager().getSubscribeService().getCountDownLatchPubSub();
    }

    @Override
    public void await() throws InterruptedException {
        if (this.getCount() == 0L) {
            return;
        }
        RFuture<RedissonCountDownLatchEntry> future = this.subscribe();
        try {
            this.commandExecutor.syncSubscriptionInterrupted(future);
            while (this.getCount() > 0L) {
                future.getNow().getLatch().await();
            }
        }
        finally {
            this.unsubscribe(future);
        }
    }

    @Override
    public RFuture<Void> awaitAsync() {
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        RFuture<Long> countFuture = this.getCountAsync();
        countFuture.onComplete((r, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            RFuture<RedissonCountDownLatchEntry> subscribeFuture = this.subscribe();
            subscribeFuture.onComplete((res, ex) -> {
                if (ex != null) {
                    result.tryFailure((Throwable)ex);
                    return;
                }
                this.await(result, subscribeFuture);
            });
        });
        return result;
    }

    private void await(RPromise<Void> result, RFuture<RedissonCountDownLatchEntry> subscribeFuture) {
        if (result.isDone()) {
            this.unsubscribe(subscribeFuture);
            return;
        }
        RFuture<Long> countFuture = this.getCountAsync();
        countFuture.onComplete((r, e) -> {
            if (e != null) {
                this.unsubscribe(subscribeFuture);
                result.tryFailure((Throwable)e);
                return;
            }
            if (r == 0L) {
                this.unsubscribe(subscribeFuture);
                result.trySuccess(null);
                return;
            }
            ((RedissonCountDownLatchEntry)subscribeFuture.getNow()).addListener(() -> this.await(result, subscribeFuture));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        long remainTime = unit.toMillis(time);
        long current = System.currentTimeMillis();
        if (this.getCount() == 0L) {
            return true;
        }
        RFuture<RedissonCountDownLatchEntry> promise = this.subscribe();
        if (!promise.await(time, unit)) {
            return false;
        }
        try {
            if ((remainTime -= System.currentTimeMillis() - current) <= 0L) {
                boolean bl = false;
                return bl;
            }
            while (this.getCount() > 0L) {
                if (remainTime <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                current = System.currentTimeMillis();
                promise.getNow().getLatch().await(remainTime, TimeUnit.MILLISECONDS);
                remainTime -= System.currentTimeMillis() - current;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.unsubscribe(promise);
        }
    }

    @Override
    public RFuture<Boolean> awaitAsync(long waitTime, TimeUnit unit) {
        RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        AtomicLong time = new AtomicLong(unit.toMillis(waitTime));
        long currentTime = System.currentTimeMillis();
        RFuture<Long> countFuture = this.getCountAsync();
        countFuture.onComplete((r, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            long el = System.currentTimeMillis() - currentTime;
            time.addAndGet(-el);
            if (time.get() <= 0L) {
                result.trySuccess(false);
                return;
            }
            long current = System.currentTimeMillis();
            AtomicReference futureRef = new AtomicReference();
            RFuture<RedissonCountDownLatchEntry> subscribeFuture = this.subscribe();
            subscribeFuture.onComplete((res, ex) -> {
                if (ex != null) {
                    result.tryFailure((Throwable)ex);
                    return;
                }
                if (futureRef.get() != null) {
                    ((Timeout)futureRef.get()).cancel();
                }
                long elapsed = System.currentTimeMillis() - current;
                time.addAndGet(-elapsed);
                this.await(time, result, subscribeFuture);
            });
        });
        return result;
    }

    private void await(final AtomicLong time, final RPromise<Boolean> result, final RFuture<RedissonCountDownLatchEntry> subscribeFuture) {
        if (result.isDone()) {
            this.unsubscribe(subscribeFuture);
            return;
        }
        if (time.get() <= 0L) {
            this.unsubscribe(subscribeFuture);
            result.trySuccess(false);
            return;
        }
        long curr = System.currentTimeMillis();
        RFuture<Long> countFuture = this.getCountAsync();
        countFuture.onComplete((r, e) -> {
            if (e != null) {
                this.unsubscribe(subscribeFuture);
                result.tryFailure((Throwable)e);
                return;
            }
            if (r == 0L) {
                this.unsubscribe(subscribeFuture);
                result.trySuccess(true);
                return;
            }
            long el = System.currentTimeMillis() - curr;
            time.addAndGet(-el);
            if (time.get() <= 0L) {
                this.unsubscribe(subscribeFuture);
                result.trySuccess(false);
                return;
            }
            final long current = System.currentTimeMillis();
            AtomicBoolean executed = new AtomicBoolean();
            final RedissonCountDownLatchEntry entry = (RedissonCountDownLatchEntry)subscribeFuture.getNow();
            AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
            final Runnable listener = () -> {
                executed.set(true);
                if (futureRef.get() != null) {
                    ((Timeout)futureRef.get()).cancel();
                }
                long elapsed = System.currentTimeMillis() - current;
                time.addAndGet(-elapsed);
                this.await(time, result, subscribeFuture);
            };
            entry.addListener(listener);
            if (!executed.get()) {
                Timeout timeoutFuture = this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

                    @Override
                    public void run(Timeout timeout) throws Exception {
                        if (entry.removeListener(listener)) {
                            long elapsed = System.currentTimeMillis() - current;
                            time.addAndGet(-elapsed);
                            RedissonCountDownLatch.this.await(time, result, subscribeFuture);
                        }
                    }
                }, time.get(), TimeUnit.MILLISECONDS);
                futureRef.set(timeoutFuture);
            }
        });
    }

    private RFuture<RedissonCountDownLatchEntry> subscribe() {
        return this.pubSub.subscribe(this.getEntryName(), this.getChannelName());
    }

    private void unsubscribe(RFuture<RedissonCountDownLatchEntry> future) {
        this.pubSub.unsubscribe(future.getNow(), this.getEntryName(), this.getChannelName());
    }

    @Override
    public void countDown() {
        this.get(this.countDownAsync());
    }

    @Override
    public RFuture<Void> countDownAsync() {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local v = redis.call('decr', KEYS[1]);if v <= 0 then redis.call('del', KEYS[1]) end;if v == 0 then redis.call('publish', KEYS[2], ARGV[1]) end;", Arrays.asList(this.getRawName(), this.getChannelName()), CountDownLatchPubSub.ZERO_COUNT_MESSAGE);
    }

    private String getEntryName() {
        return this.id + this.getRawName();
    }

    private String getChannelName() {
        return "redisson_countdownlatch__channel__{" + this.getRawName() + "}";
    }

    @Override
    public long getCount() {
        return this.get(this.getCountAsync());
    }

    @Override
    public RFuture<Long> getCountAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.GET_LONG, this.getRawName());
    }

    @Override
    public boolean trySetCount(long count) {
        return this.get(this.trySetCountAsync(count));
    }

    @Override
    public RFuture<Boolean> trySetCountAsync(long count) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('exists', KEYS[1]) == 0 then redis.call('set', KEYS[1], ARGV[2]); redis.call('publish', KEYS[2], ARGV[1]); return 1 else return 0 end", Arrays.asList(this.getRawName(), this.getChannelName()), CountDownLatchPubSub.NEW_COUNT_MESSAGE, count);
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('del', KEYS[1]) == 1 then redis.call('publish', KEYS[2], ARGV[1]); return 1 else return 0 end", Arrays.asList(this.getRawName(), this.getChannelName()), CountDownLatchPubSub.NEW_COUNT_MESSAGE);
    }
}

