/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import org.redisson.RedissonExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RSemaphore;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.MessageListener;
import org.redisson.client.codec.LongCodec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RedissonBaseAdder<T extends Number>
extends RedissonExpirable {
    private static final Logger log = LoggerFactory.getLogger(RedissonBaseAdder.class);
    private static final long CLEAR_MSG = 0L;
    private static final long SUM_MSG = 1L;
    private final RSemaphore semaphore;
    private final RTopic topic;
    private final int listenerId;

    public RedissonBaseAdder(CommandAsyncExecutor connectionManager, String name, RedissonClient redisson) {
        super(connectionManager, name);
        this.topic = redisson.getTopic(RedissonBaseAdder.suffixName(this.getName(), "topic"), LongCodec.INSTANCE);
        this.semaphore = redisson.getSemaphore(RedissonBaseAdder.suffixName(this.getName(), "semaphore"));
        this.listenerId = this.topic.addListener(Long.class, new MessageListener<Long>(){

            @Override
            public void onMessage(CharSequence channel, Long msg) {
                if (msg == 1L) {
                    RFuture addAndGetFuture = RedissonBaseAdder.this.addAndGetAsync();
                    addAndGetFuture.onComplete((res, e) -> {
                        if (e != null) {
                            log.error("Can't increase sum", (Throwable)e);
                            return;
                        }
                        RedissonBaseAdder.this.semaphore.releaseAsync().onComplete((r, ex) -> {
                            if (ex != null) {
                                log.error("Can't release semaphore", (Throwable)ex);
                                return;
                            }
                        });
                    });
                }
                if (msg == 0L) {
                    RedissonBaseAdder.this.doReset();
                    RedissonBaseAdder.this.semaphore.releaseAsync().onComplete((res, e) -> {
                        if (e != null) {
                            log.error("Can't release semaphore", (Throwable)e);
                        }
                    });
                }
            }
        });
    }

    protected abstract void doReset();

    public void reset() {
        this.get(this.resetAsync());
    }

    public void reset(long timeout, TimeUnit timeUnit) {
        this.get(this.resetAsync(timeout, timeUnit));
    }

    public RFuture<T> sumAsync() {
        RedissonPromise result = new RedissonPromise();
        RFuture<Long> future = this.topic.publishAsync(1L);
        future.onComplete(new SumListener(result));
        return result;
    }

    public RFuture<T> sumAsync(final long timeout, final TimeUnit timeUnit) {
        RedissonPromise result = new RedissonPromise();
        RFuture<Long> future = this.topic.publishAsync(1L);
        future.onComplete(new SumListener(result){

            @Override
            protected RFuture<Void> acquireAsync(int value) {
                return RedissonBaseAdder.this.tryAcquire(timeout, timeUnit, value);
            }
        });
        return result;
    }

    protected RFuture<Void> tryAcquire(long timeout, TimeUnit timeUnit, int value) {
        RedissonPromise<Void> acquireResult = new RedissonPromise<Void>();
        this.semaphore.tryAcquireAsync(value, timeout, timeUnit).onComplete((res, e) -> {
            if (e != null) {
                acquireResult.tryFailure((Throwable)e);
                return;
            }
            if (res.booleanValue()) {
                acquireResult.trySuccess(null);
            } else {
                acquireResult.tryFailure(new TimeoutException());
            }
        });
        return acquireResult;
    }

    public RFuture<Void> resetAsync() {
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        RFuture<Long> future = this.topic.publishAsync(0L);
        future.onComplete(new ResetListener(result));
        return result;
    }

    public RFuture<Void> resetAsync(final long timeout, final TimeUnit timeUnit) {
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        RFuture<Long> future = this.topic.publishAsync(0L);
        future.onComplete(new ResetListener(result){

            @Override
            protected RFuture<Void> acquireAsync(int value) {
                return RedissonBaseAdder.this.tryAcquire(timeout, timeUnit, value);
            }
        });
        return result;
    }

    public void destroy() {
        this.topic.removeListener(this.listenerId);
    }

    protected abstract RFuture<T> addAndGetAsync();

    protected abstract RFuture<T> getAndDeleteAsync();

    private class SumListener
    implements BiConsumer<Long, Throwable> {
        private final RPromise<T> result;

        SumListener(RPromise<T> result) {
            this.result = result;
        }

        @Override
        public void accept(Long t, Throwable u) {
            if (u != null) {
                this.result.tryFailure(u);
                return;
            }
            this.acquireAsync(t.intValue()).onComplete((r, e) -> {
                if (e != null) {
                    this.result.tryFailure((Throwable)e);
                    return;
                }
                RFuture valueFuture = RedissonBaseAdder.this.getAndDeleteAsync();
                valueFuture.onComplete((res, ex) -> {
                    if (ex != null) {
                        this.result.tryFailure((Throwable)ex);
                        return;
                    }
                    this.result.trySuccess((Number)res);
                });
            });
        }

        protected RFuture<Void> acquireAsync(int value) {
            return RedissonBaseAdder.this.semaphore.acquireAsync(value);
        }
    }

    private class ResetListener
    implements BiConsumer<Long, Throwable> {
        private final RPromise<Void> result;

        ResetListener(RPromise<Void> result) {
            this.result = result;
        }

        @Override
        public void accept(Long t, Throwable u) {
            if (u != null) {
                this.result.tryFailure(u);
                return;
            }
            this.acquireAsync(t.intValue()).onComplete((res, e) -> {
                if (e != null) {
                    this.result.tryFailure((Throwable)e);
                    return;
                }
                this.result.trySuccess(null);
            });
        }

        protected RFuture<Void> acquireAsync(int value) {
            return RedissonBaseAdder.this.semaphore.acquireAsync(value);
        }
    }
}

