/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Collections;
import org.redisson.RedissonExpirable;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonAtomicLong
extends RedissonExpirable
implements RAtomicLong {
    public RedissonAtomicLong(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    @Override
    public long addAndGet(long delta) {
        return this.get(this.addAndGetAsync(delta));
    }

    @Override
    public RFuture<Long> addAndGetAsync(long delta) {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.INCRBY, this.getName(), delta);
    }

    @Override
    public boolean compareAndSet(long expect, long update) {
        return this.get(this.compareAndSetAsync(expect, update));
    }

    @Override
    public RFuture<Boolean> compareAndSetAsync(long expect, long update) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local currValue = redis.call('get', KEYS[1]); if currValue == ARGV[1] or (tonumber(ARGV[1]) == 0 and currValue == false) then redis.call('set', KEYS[1], ARGV[2]); return 1 else return 0 end", Collections.singletonList(this.getName()), expect, update);
    }

    @Override
    public long getAndDelete() {
        return this.get(this.getAndDeleteAsync());
    }

    @Override
    public RFuture<Long> getAndDeleteAsync() {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_LONG_SAFE, "local currValue = redis.call('get', KEYS[1]); redis.call('del', KEYS[1]); return currValue; ", Collections.singletonList(this.getName()), new Object[0]);
    }

    @Override
    public long decrementAndGet() {
        return this.get(this.decrementAndGetAsync());
    }

    @Override
    public RFuture<Long> decrementAndGetAsync() {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.DECR, this.getName());
    }

    @Override
    public long get() {
        return this.get(this.getAsync());
    }

    @Override
    public RFuture<Long> getAsync() {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.GET_LONG, this.getName());
    }

    @Override
    public long getAndAdd(long delta) {
        return this.get(this.getAndAddAsync(delta));
    }

    @Override
    public RFuture<Long> getAndAddAsync(final long delta) {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, new RedisStrictCommand<Long>("INCRBY", new Convertor<Long>(){

            @Override
            public Long convert(Object obj) {
                return (Long)obj - delta;
            }
        }), this.getName(), delta);
    }

    @Override
    public long getAndSet(long newValue) {
        return this.get(this.getAndSetAsync(newValue));
    }

    @Override
    public RFuture<Long> getAndSetAsync(long newValue) {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.GETSET, this.getName(), newValue);
    }

    @Override
    public long incrementAndGet() {
        return this.get(this.incrementAndGetAsync());
    }

    @Override
    public RFuture<Long> incrementAndGetAsync() {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.INCR, this.getName());
    }

    @Override
    public long getAndIncrement() {
        return this.getAndAdd(1L);
    }

    @Override
    public RFuture<Long> getAndIncrementAsync() {
        return this.getAndAddAsync(1L);
    }

    @Override
    public long getAndDecrement() {
        return this.getAndAdd(-1L);
    }

    @Override
    public RFuture<Long> getAndDecrementAsync() {
        return this.getAndAddAsync(-1L);
    }

    @Override
    public void set(long newValue) {
        this.get(this.setAsync(newValue));
    }

    @Override
    public RFuture<Void> setAsync(long newValue) {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.SET, this.getName(), newValue);
    }

    public String toString() {
        return Long.toString(this.get());
    }
}

