/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscribers.InnerQueuedSubscriber;
import io.reactivex.internal.subscribers.InnerQueuedSubscriberSupport;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.ErrorMode;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableConcatMapEager<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Function<? super T, ? extends Publisher<? extends R>> mapper;
    final int maxConcurrency;
    final int prefetch;
    final ErrorMode errorMode;

    public FlowableConcatMapEager(Flowable<T> source, Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency, int prefetch, ErrorMode errorMode) {
        super(source);
        this.mapper = mapper;
        this.maxConcurrency = maxConcurrency;
        this.prefetch = prefetch;
        this.errorMode = errorMode;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        this.source.subscribe(new ConcatMapEagerDelayErrorSubscriber<T, R>(s, this.mapper, this.maxConcurrency, this.prefetch, this.errorMode));
    }

    static final class ConcatMapEagerDelayErrorSubscriber<T, R>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription,
    InnerQueuedSubscriberSupport<R> {
        private static final long serialVersionUID = -4255299542215038287L;
        final Subscriber<? super R> downstream;
        final Function<? super T, ? extends Publisher<? extends R>> mapper;
        final int maxConcurrency;
        final int prefetch;
        final ErrorMode errorMode;
        final AtomicThrowable errors;
        final AtomicLong requested;
        final SpscLinkedArrayQueue<InnerQueuedSubscriber<R>> subscribers;
        Subscription upstream;
        volatile boolean cancelled;
        volatile boolean done;
        volatile InnerQueuedSubscriber<R> current;

        ConcatMapEagerDelayErrorSubscriber(Subscriber<? super R> actual, Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency, int prefetch, ErrorMode errorMode) {
            this.downstream = actual;
            this.mapper = mapper;
            this.maxConcurrency = maxConcurrency;
            this.prefetch = prefetch;
            this.errorMode = errorMode;
            this.subscribers = new SpscLinkedArrayQueue(Math.min(prefetch, maxConcurrency));
            this.errors = new AtomicThrowable();
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
                s.request(this.maxConcurrency == Integer.MAX_VALUE ? Long.MAX_VALUE : (long)this.maxConcurrency);
            }
        }

        @Override
        public void onNext(T t) {
            Publisher<R> p;
            try {
                p = ObjectHelper.requireNonNull(this.mapper.apply(t), "The mapper returned a null Publisher");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.upstream.cancel();
                this.onError(ex);
                return;
            }
            InnerQueuedSubscriber inner = new InnerQueuedSubscriber(this, this.prefetch);
            if (this.cancelled) {
                return;
            }
            this.subscribers.offer(inner);
            p.subscribe(inner);
            if (this.cancelled) {
                inner.cancel();
                this.drainAndCancel();
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.errors.addThrowable(t)) {
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.upstream.cancel();
            this.drainAndCancel();
        }

        void drainAndCancel() {
            if (this.getAndIncrement() == 0) {
                do {
                    this.cancelAll();
                } while (this.decrementAndGet() != 0);
            }
        }

        void cancelAll() {
            InnerQueuedSubscriber<R> inner = this.current;
            this.current = null;
            if (inner != null) {
                inner.cancel();
            }
            while ((inner = this.subscribers.poll()) != null) {
                inner.cancel();
            }
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        @Override
        public void innerNext(InnerQueuedSubscriber<R> inner, R value) {
            if (inner.queue().offer(value)) {
                this.drain();
            } else {
                inner.cancel();
                this.innerError(inner, (Throwable)new MissingBackpressureException());
            }
        }

        @Override
        public void innerError(InnerQueuedSubscriber<R> inner, Throwable e) {
            if (this.errors.addThrowable(e)) {
                inner.setDone();
                if (this.errorMode != ErrorMode.END) {
                    this.upstream.cancel();
                }
                this.drain();
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void innerComplete(InnerQueuedSubscriber<R> inner) {
            inner.setDone();
            this.drain();
        }

        @Override
        public void drain() {
            boolean continueNextSource;
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            InnerQueuedSubscriber<R> inner = this.current;
            Subscriber<R> a = this.downstream;
            ErrorMode em = this.errorMode;
            do {
                SimpleQueue<R> q;
                long r = this.requested.get();
                long e = 0L;
                if (inner == null) {
                    Throwable ex;
                    if (em != ErrorMode.END && (ex = (Throwable)this.errors.get()) != null) {
                        this.cancelAll();
                        a.onError(this.errors.terminate());
                        return;
                    }
                    boolean outerDone = this.done;
                    inner = this.subscribers.poll();
                    if (outerDone && inner == null) {
                        Throwable ex2 = this.errors.terminate();
                        if (ex2 != null) {
                            a.onError(ex2);
                        } else {
                            a.onComplete();
                        }
                        return;
                    }
                    if (inner != null) {
                        this.current = inner;
                    }
                }
                continueNextSource = false;
                if (inner != null && (q = inner.queue()) != null) {
                    boolean d;
                    while (e != r) {
                        boolean empty;
                        R v;
                        Throwable ex;
                        if (this.cancelled) {
                            this.cancelAll();
                            return;
                        }
                        if (em == ErrorMode.IMMEDIATE && (ex = (Throwable)this.errors.get()) != null) {
                            this.current = null;
                            inner.cancel();
                            this.cancelAll();
                            a.onError(this.errors.terminate());
                            return;
                        }
                        d = inner.isDone();
                        try {
                            v = q.poll();
                        }
                        catch (Throwable ex3) {
                            Exceptions.throwIfFatal(ex3);
                            this.current = null;
                            inner.cancel();
                            this.cancelAll();
                            a.onError(ex3);
                            return;
                        }
                        boolean bl = empty = v == null;
                        if (d && empty) {
                            inner = null;
                            this.current = null;
                            this.upstream.request(1L);
                            continueNextSource = true;
                            break;
                        }
                        if (empty) break;
                        a.onNext(v);
                        ++e;
                        inner.requestOne();
                    }
                    if (e == r) {
                        Throwable ex;
                        if (this.cancelled) {
                            this.cancelAll();
                            return;
                        }
                        if (em == ErrorMode.IMMEDIATE && (ex = (Throwable)this.errors.get()) != null) {
                            this.current = null;
                            inner.cancel();
                            this.cancelAll();
                            a.onError(this.errors.terminate());
                            return;
                        }
                        d = inner.isDone();
                        boolean empty = q.isEmpty();
                        if (d && empty) {
                            inner = null;
                            this.current = null;
                            this.upstream.request(1L);
                            continueNextSource = true;
                        }
                    }
                }
                if (e == 0L || r == Long.MAX_VALUE) continue;
                this.requested.addAndGet(-e);
            } while (continueNextSource || (missed = this.addAndGet(-missed)) != 0);
        }
    }
}

