/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.internal;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import reactor.core.internal.PlatformDependent0;

public class PlatformDependent {
    private static final boolean HAS_UNSAFE = PlatformDependent.hasUnsafe0();

    public static <U, W> AtomicReferenceFieldUpdater<U, W> newAtomicReferenceFieldUpdater(Class<U> tclass, String fieldName) {
        if (PlatformDependent.hasUnsafe()) {
            try {
                return PlatformDependent0.newAtomicReferenceFieldUpdater(tclass, fieldName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean hasUnsafe() {
        return HAS_UNSAFE;
    }

    private static boolean isAndroid() {
        boolean android;
        try {
            Class.forName("android.app.Application", false, PlatformDependent0.getSystemClassLoader());
            android = true;
        }
        catch (Exception e) {
            android = false;
        }
        return android;
    }

    private static boolean hasUnsafe0() {
        if (PlatformDependent.isAndroid()) {
            return false;
        }
        try {
            return PlatformDependent0.hasUnsafe();
        }
        catch (Throwable t) {
            return false;
        }
    }
}

