/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.error;

import org.reactivestreams.Publisher;
import reactor.fn.Consumer;
import reactor.rx.action.error.FallbackAction;

public final class ErrorAction<T, E extends Throwable>
extends FallbackAction<T> {
    private final Consumer<? super E> consumer;
    private final Class<E> selector;

    public ErrorAction(Class<E> selector, Consumer<? super E> consumer, Publisher<? extends T> fallback) {
        super(fallback);
        this.consumer = consumer;
        this.selector = selector;
    }

    @Override
    protected void doNormalNext(T ev) {
        this.broadcastNext(ev);
    }

    @Override
    protected void doError(Throwable cause) {
        if (this.selector.isAssignableFrom(cause.getClass())) {
            if (this.consumer != null) {
                this.consumer.accept(cause);
            } else if (this.fallback != null) {
                this.doSwitch();
                return;
            }
        }
        super.doError(cause);
    }

    @Override
    public String toString() {
        return super.toString() + "{" + "catch-type=" + this.selector + '}';
    }
}

