/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol.decoder;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.DoubleCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class GeoDistanceDecoder
implements MultiDecoder<List<Object>> {
    private final ThreadLocal<Integer> pos = new ThreadLocal();
    private final Codec codec;

    public GeoDistanceDecoder(Codec codec) {
        this.codec = codec;
    }

    @Override
    public Object decode(ByteBuf buf, State state) throws IOException {
        if (this.pos.get() % 2 == 0) {
            return this.codec.getValueDecoder().decode(buf, state);
        }
        return DoubleCodec.INSTANCE.getValueDecoder().decode(buf, state);
    }

    @Override
    public boolean isApplicable(int paramNum, State state) {
        this.pos.set(paramNum);
        return true;
    }

    @Override
    public List<Object> decode(List<Object> parts, State state) {
        return parts;
    }
}

