/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.codec;

import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class StringCodec
implements Codec {
    public static final StringCodec INSTANCE = new StringCodec();
    private final Charset charset;
    private final Encoder encoder = new Encoder(){

        @Override
        public byte[] encode(Object in) throws IOException {
            return in.toString().getBytes(StringCodec.this.charset);
        }
    };
    private final Decoder<Object> decoder = new Decoder<Object>(){

        @Override
        public Object decode(ByteBuf buf, State state) {
            String str = buf.toString(StringCodec.this.charset);
            buf.readerIndex(buf.readableBytes());
            return str;
        }
    };

    public StringCodec() {
        this(CharsetUtil.UTF_8);
    }

    public StringCodec(ClassLoader classLoader) {
        this();
    }

    public StringCodec(String charsetName) {
        this(Charset.forName(charsetName));
    }

    public StringCodec(Charset charset) {
        this.charset = charset;
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }

    @Override
    public Decoder<Object> getMapValueDecoder() {
        return this.getValueDecoder();
    }

    @Override
    public Encoder getMapValueEncoder() {
        return this.getValueEncoder();
    }

    @Override
    public Decoder<Object> getMapKeyDecoder() {
        return this.getValueDecoder();
    }

    @Override
    public Encoder getMapKeyEncoder() {
        return this.getValueEncoder();
    }
}

