/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.passive;

import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.fn.Consumer;
import reactor.rx.action.Action;

public class StreamStateCallbackAction<T>
extends Action<T, T> {
    private final Consumer<? super Subscriber<? super T>> subscribeConsumer;
    private final Consumer<Void> cancelConsumer;
    private final Consumer<? super Subscription> onSubscribeConsumer;

    public StreamStateCallbackAction(Consumer<? super Subscriber<? super T>> subscribeConsumer, Consumer<Void> cancelConsumer, Consumer<? super Subscription> onSubscribeConsumer) {
        this.subscribeConsumer = subscribeConsumer;
        this.cancelConsumer = cancelConsumer;
        this.onSubscribeConsumer = onSubscribeConsumer;
    }

    @Override
    protected void doOnSubscribe(Subscription subscription) {
        if (this.onSubscribeConsumer != null) {
            this.onSubscribeConsumer.accept(subscription);
        }
        super.doOnSubscribe(subscription);
    }

    @Override
    protected void doNext(T ev) {
        this.broadcastNext(ev);
    }

    @Override
    protected void doShutdown() {
        if (this.cancelConsumer != null) {
            this.cancelConsumer.accept(null);
        }
        super.doShutdown();
    }

    @Override
    public void subscribe(Subscriber<? super T> subscriber) {
        if (this.subscribeConsumer != null) {
            this.subscribeConsumer.accept(subscriber);
        }
        super.subscribe(subscriber);
    }
}

