/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import io.netty.util.internal.ThreadLocalRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;

public class RedissonMultiLock
implements Lock {
    final List<RLock> locks = new ArrayList<RLock>();

    public RedissonMultiLock(RLock ... locks) {
        if (locks.length == 0) {
            throw new IllegalArgumentException("Lock objects are not defined");
        }
        this.locks.addAll(Arrays.asList(locks));
    }

    @Override
    public void lock() {
        try {
            this.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void lock(long leaseTime, TimeUnit unit) {
        try {
            this.lockInterruptibly(leaseTime, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lockInterruptibly(-1L, null);
    }

    public void lockInterruptibly(long leaseTime, TimeUnit unit) throws InterruptedException {
        long waitTime = -1L;
        if (leaseTime == -1L) {
            waitTime = 5L;
            unit = TimeUnit.SECONDS;
        } else {
            waitTime = unit.toMillis(leaseTime);
            waitTime = waitTime <= 2000L ? 2000L : (waitTime <= 5000L ? ThreadLocalRandom.current().nextLong(waitTime / 2L, waitTime) : ThreadLocalRandom.current().nextLong(5000L, waitTime));
            waitTime = unit.convert(waitTime, TimeUnit.MILLISECONDS);
        }
        while (!this.tryLock(waitTime, leaseTime, unit)) {
        }
    }

    @Override
    public boolean tryLock() {
        try {
            return this.tryLock(-1L, -1L, null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    protected void unlockInner(Collection<RLock> locks) {
        ArrayList<RFuture<Void>> futures = new ArrayList<RFuture<Void>>(locks.size());
        for (RLock rLock : locks) {
            futures.add(rLock.unlockAsync());
        }
        for (RFuture rFuture : futures) {
            rFuture.awaitUninterruptibly();
        }
    }

    @Override
    public boolean tryLock(long waitTime, TimeUnit unit) throws InterruptedException {
        return this.tryLock(waitTime, -1L, unit);
    }

    protected int failedLocksLimit() {
        return 0;
    }

    public boolean tryLock(long waitTime, long leaseTime, TimeUnit unit) throws InterruptedException {
        long newLeaseTime = -1L;
        if (leaseTime != -1L) {
            newLeaseTime = waitTime * 2L;
        }
        long time = System.currentTimeMillis();
        long remainTime = -1L;
        if (waitTime != -1L) {
            remainTime = unit.toMillis(waitTime);
        }
        int failedLocksLimit = this.failedLocksLimit();
        ArrayList<RLock> lockedLocks = new ArrayList<RLock>(this.locks.size());
        ListIterator<RLock> iterator = this.locks.listIterator();
        while (iterator.hasNext()) {
            boolean bl;
            RLock lock = iterator.next();
            try {
                if (waitTime == -1L && leaseTime == -1L) {
                    bl = lock.tryLock();
                } else {
                    long awaitTime = unit.convert(remainTime, TimeUnit.MILLISECONDS);
                    bl = lock.tryLock(awaitTime, newLeaseTime, unit);
                }
            }
            catch (Exception e) {
                bl = false;
            }
            if (bl) {
                lockedLocks.add(lock);
            } else {
                if (this.locks.size() - lockedLocks.size() == this.failedLocksLimit()) break;
                if (failedLocksLimit == 0) {
                    this.unlockInner(lockedLocks);
                    if (waitTime == -1L && leaseTime == -1L) {
                        return false;
                    }
                    failedLocksLimit = this.failedLocksLimit();
                    lockedLocks.clear();
                    while (iterator.hasPrevious()) {
                        iterator.previous();
                    }
                } else {
                    --failedLocksLimit;
                }
            }
            if (remainTime == -1L) continue;
            time = System.currentTimeMillis();
            if ((remainTime -= System.currentTimeMillis() - time) > 0L) continue;
            this.unlockInner(lockedLocks);
            return false;
        }
        if (leaseTime != -1L) {
            ArrayList<RFuture<Boolean>> futures = new ArrayList<RFuture<Boolean>>(lockedLocks.size());
            for (RLock rLock : lockedLocks) {
                RFuture<Boolean> future = rLock.expireAsync(unit.toMillis(leaseTime), TimeUnit.MILLISECONDS);
                futures.add(future);
            }
            for (RFuture rFuture : futures) {
                rFuture.syncUninterruptibly();
            }
        }
        return true;
    }

    @Override
    public void unlock() {
        ArrayList<RFuture<Void>> futures = new ArrayList<RFuture<Void>>(this.locks.size());
        for (RLock rLock : this.locks) {
            futures.add(rLock.unlockAsync());
        }
        for (RFuture rFuture : futures) {
            rFuture.syncUninterruptibly();
        }
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    protected boolean isLockFailed(Future<Boolean> future) {
        return !future.isSuccess();
    }

    protected boolean isAllLocksAcquired(AtomicReference<RLock> lockedLockHolder, AtomicReference<Throwable> failed, Queue<RLock> lockedLocks) {
        return lockedLockHolder.get() == null && failed.get() == null;
    }
}

