/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx;

import java.io.IOException;
import org.reactivestreams.Publisher;
import reactor.Environment;
import reactor.io.codec.Codec;
import reactor.rx.Stream;
import reactor.rx.Streams;
import reactor.rx.stream.MapStream;
import reactor.rx.stream.io.ChronicleReaderStream;
import reactor.rx.stream.io.ChronicleStream;

public class IOStreams
extends Streams {
    private IOStreams() {
    }

    public static <KEY, VALUE> MapStream<KEY, VALUE> persistentMap(String name) {
        return IOStreams.persistentMap(name, false);
    }

    public static <KEY, VALUE> MapStream<KEY, VALUE> persistentMap(String name, boolean deleteOnExit) {
        ChronicleStream chronicleStream;
        try {
            chronicleStream = new ChronicleStream(name);
        }
        catch (IOException e) {
            if (Environment.alive()) {
                Environment.get().routeError(e);
            }
            return null;
        }
        if (deleteOnExit) {
            chronicleStream.deleteOnExit();
        }
        return chronicleStream;
    }

    public static <KEY, VALUE> MapStream<KEY, VALUE> persistentMapReader(String name) {
        try {
            return new ChronicleReaderStream(name);
        }
        catch (IOException e) {
            if (Environment.alive()) {
                Environment.get().routeError(e);
            }
            return null;
        }
    }

    public static <SRC, IN> Stream<IN> decode(Codec<SRC, IN, ?> codec, Publisher<? extends SRC> publisher) {
        return Streams.wrap(codec.decode(publisher));
    }
}

