/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.redisson.client.protocol.decoder.ListScanResult;

abstract class RedissonBaseIterator<V>
implements Iterator<V> {
    private List<V> firstValues;
    private List<V> lastValues;
    private Iterator<V> lastIter;
    protected long nextIterPos;
    protected InetSocketAddress client;
    private boolean finished;
    private boolean currentElementRemoved;
    private boolean removeExecuted;
    private V value;

    RedissonBaseIterator() {
    }

    @Override
    public boolean hasNext() {
        if (this.lastIter == null || !this.lastIter.hasNext()) {
            long prevIterPos;
            if (this.finished) {
                this.currentElementRemoved = false;
                this.removeExecuted = false;
                this.client = null;
                this.firstValues = null;
                this.lastValues = null;
                this.nextIterPos = 0L;
                if (!this.tryAgain()) {
                    return false;
                }
                this.finished = false;
            }
            do {
                prevIterPos = this.nextIterPos;
                ListScanResult<V> res = this.iterator(this.client, this.nextIterPos);
                this.lastValues = new ArrayList<V>(res.getValues());
                this.client = res.getRedisClient();
                if (this.nextIterPos == 0L && this.firstValues == null) {
                    this.firstValues = this.lastValues;
                    this.lastValues = null;
                    if (this.firstValues.isEmpty() && this.tryAgain()) {
                        this.client = null;
                        this.firstValues = null;
                        this.nextIterPos = 0L;
                        prevIterPos = -1L;
                    }
                } else if (this.firstValues.isEmpty()) {
                    this.firstValues = this.lastValues;
                    this.lastValues = null;
                    if (this.firstValues.isEmpty()) {
                        if (this.tryAgain()) {
                            this.client = null;
                            this.firstValues = null;
                            this.nextIterPos = 0L;
                            prevIterPos = -1L;
                            continue;
                        }
                        if (res.getPos() == 0L) {
                            this.finished = true;
                            return false;
                        }
                    }
                } else if (this.lastValues.removeAll(this.firstValues)) {
                    this.currentElementRemoved = false;
                    this.removeExecuted = false;
                    this.client = null;
                    this.firstValues = null;
                    this.lastValues = null;
                    this.nextIterPos = 0L;
                    prevIterPos = -1L;
                    if (this.tryAgain()) continue;
                    this.finished = true;
                    return false;
                }
                this.lastIter = res.getValues().iterator();
                this.nextIterPos = res.getPos();
            } while (!this.lastIter.hasNext() && this.nextIterPos != prevIterPos);
            if (prevIterPos == this.nextIterPos && !this.removeExecuted) {
                this.finished = true;
            }
        }
        return this.lastIter.hasNext();
    }

    protected boolean tryAgain() {
        return false;
    }

    abstract ListScanResult<V> iterator(InetSocketAddress var1, long var2);

    @Override
    public V next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No such element");
        }
        this.value = this.lastIter.next();
        this.currentElementRemoved = false;
        return this.value;
    }

    @Override
    public void remove() {
        if (this.currentElementRemoved) {
            throw new IllegalStateException("Element been already deleted");
        }
        if (this.lastIter == null) {
            throw new IllegalStateException();
        }
        this.firstValues.remove(this.value);
        this.lastIter.remove();
        this.remove(this.value);
        this.currentElementRemoved = true;
        this.removeExecuted = true;
    }

    abstract void remove(V var1);
}

