/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility;

import java.util.Arrays;

public enum PropertyDispatcher {
    BOOLEAN_ARRAY{

        @Override
        public String toString(Object value) {
            return Arrays.toString((boolean[])value);
        }

        @Override
        public int hashCode(Object value) {
            return Arrays.hashCode((boolean[])value);
        }

        @Override
        protected boolean doEquals(Object first, Object second) {
            return Arrays.equals((boolean[])first, (boolean[])second);
        }

        @Override
        public <T> T conditionalClone(T value) {
            boolean[] castValue = (boolean[])value;
            return (T)(castValue.length == 0 ? value : castValue.clone());
        }
    }
    ,
    BYTE_ARRAY{

        @Override
        public String toString(Object value) {
            return Arrays.toString((byte[])value);
        }

        @Override
        public int hashCode(Object value) {
            return Arrays.hashCode((byte[])value);
        }

        @Override
        protected boolean doEquals(Object first, Object second) {
            return Arrays.equals((byte[])first, (byte[])second);
        }

        @Override
        public <T> T conditionalClone(T value) {
            byte[] castValue = (byte[])value;
            return (T)(castValue.length == 0 ? value : castValue.clone());
        }
    }
    ,
    SHORT_ARRAY{

        @Override
        public String toString(Object value) {
            return Arrays.toString((short[])value);
        }

        @Override
        public int hashCode(Object value) {
            return Arrays.hashCode((short[])value);
        }

        @Override
        protected boolean doEquals(Object first, Object second) {
            return Arrays.equals((short[])first, (short[])second);
        }

        @Override
        public <T> T conditionalClone(T value) {
            short[] castValue = (short[])value;
            return (T)(castValue.length == 0 ? value : castValue.clone());
        }
    }
    ,
    CHARACTER_ARRAY{

        @Override
        public String toString(Object value) {
            return Arrays.toString((char[])value);
        }

        @Override
        public int hashCode(Object value) {
            return Arrays.hashCode((char[])value);
        }

        @Override
        protected boolean doEquals(Object first, Object second) {
            return Arrays.equals((char[])first, (char[])second);
        }

        @Override
        public <T> T conditionalClone(T value) {
            char[] castValue = (char[])value;
            return (T)(castValue.length == 0 ? value : castValue.clone());
        }
    }
    ,
    INTEGER_ARRAY{

        @Override
        public String toString(Object value) {
            return Arrays.toString((int[])value);
        }

        @Override
        public int hashCode(Object value) {
            return Arrays.hashCode((int[])value);
        }

        @Override
        protected boolean doEquals(Object first, Object second) {
            return Arrays.equals((int[])first, (int[])second);
        }

        @Override
        public <T> T conditionalClone(T value) {
            int[] castValue = (int[])value;
            return (T)(castValue.length == 0 ? value : castValue.clone());
        }
    }
    ,
    LONG_ARRAY{

        @Override
        public String toString(Object value) {
            return Arrays.toString((long[])value);
        }

        @Override
        public int hashCode(Object value) {
            return Arrays.hashCode((long[])value);
        }

        @Override
        protected boolean doEquals(Object first, Object second) {
            return Arrays.equals((long[])first, (long[])second);
        }

        @Override
        public <T> T conditionalClone(T value) {
            long[] castValue = (long[])value;
            return (T)(castValue.length == 0 ? value : castValue.clone());
        }
    }
    ,
    FLOAT_ARRAY{

        @Override
        public String toString(Object value) {
            return Arrays.toString((float[])value);
        }

        @Override
        public int hashCode(Object value) {
            return Arrays.hashCode((float[])value);
        }

        @Override
        protected boolean doEquals(Object first, Object second) {
            return Arrays.equals((float[])first, (float[])second);
        }

        @Override
        public <T> T conditionalClone(T value) {
            float[] castValue = (float[])value;
            return (T)(castValue.length == 0 ? value : castValue.clone());
        }
    }
    ,
    DOUBLE_ARRAY{

        @Override
        public String toString(Object value) {
            return Arrays.toString((double[])value);
        }

        @Override
        public int hashCode(Object value) {
            return Arrays.hashCode((double[])value);
        }

        @Override
        protected boolean doEquals(Object first, Object second) {
            return Arrays.equals((double[])first, (double[])second);
        }

        @Override
        public <T> T conditionalClone(T value) {
            double[] castValue = (double[])value;
            return (T)(castValue.length == 0 ? value : castValue.clone());
        }
    }
    ,
    REFERENCE_ARRAY{

        @Override
        public String toString(Object value) {
            return Arrays.toString((Object[])value);
        }

        @Override
        public int hashCode(Object value) {
            return Arrays.hashCode((Object[])value);
        }

        @Override
        protected boolean doEquals(Object first, Object second) {
            return Arrays.equals((Object[])first, (Object[])second);
        }

        @Override
        public <T> T conditionalClone(T value) {
            Object[] castValue = (Object[])value;
            return (T)(castValue.length == 0 ? value : castValue.clone());
        }
    }
    ,
    NON_ARRAY{

        @Override
        public String toString(Object value) {
            return value.toString();
        }

        @Override
        public int hashCode(Object value) {
            return value.hashCode();
        }

        @Override
        protected boolean doEquals(Object first, Object second) {
            return first.equals(second);
        }

        @Override
        public <T> T conditionalClone(T value) {
            return value;
        }
    };


    public static PropertyDispatcher of(Class<?> type) {
        if (type == boolean[].class) {
            return BOOLEAN_ARRAY;
        }
        if (type == byte[].class) {
            return BYTE_ARRAY;
        }
        if (type == short[].class) {
            return SHORT_ARRAY;
        }
        if (type == char[].class) {
            return CHARACTER_ARRAY;
        }
        if (type == int[].class) {
            return INTEGER_ARRAY;
        }
        if (type == long[].class) {
            return LONG_ARRAY;
        }
        if (type == float[].class) {
            return FLOAT_ARRAY;
        }
        if (type == double[].class) {
            return DOUBLE_ARRAY;
        }
        if (Object[].class.isAssignableFrom(type)) {
            return REFERENCE_ARRAY;
        }
        return NON_ARRAY;
    }

    public abstract String toString(Object var1);

    public abstract int hashCode(Object var1);

    public boolean equals(Object first, Object second) {
        return second != null && (first == second || PropertyDispatcher.of(second.getClass()) == this && this.doEquals(first, second));
    }

    protected abstract boolean doEquals(Object var1, Object var2);

    public abstract <T> T conditionalClone(T var1);

    public String toString() {
        return "PropertyDispatcher." + this.name();
    }
}

