/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold.subclass;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.MethodTransformer;
import net.bytebuddy.dynamic.scaffold.MethodRegistry;
import net.bytebuddy.implementation.SuperMethodCall;
import net.bytebuddy.implementation.attribute.MethodAttributeAppender;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.matcher.LatentMatcher;

public interface ConstructorStrategy {
    public List<MethodDescription.Token> extractConstructors(TypeDescription var1);

    public MethodRegistry inject(MethodRegistry var1);

    public static enum Default implements ConstructorStrategy
    {
        NO_CONSTRUCTORS{

            @Override
            protected List<MethodDescription.Token> doExtractConstructors(TypeDescription superClass) {
                return Collections.emptyList();
            }

            @Override
            public MethodRegistry inject(MethodRegistry methodRegistry) {
                return methodRegistry;
            }
        }
        ,
        DEFAULT_CONSTRUCTOR{

            @Override
            protected List<MethodDescription.Token> doExtractConstructors(TypeDescription instrumentedType) {
                MethodList.Empty defaultConstructors;
                TypeDescription.Generic superClass = instrumentedType.getSuperClass();
                MethodList methodList = defaultConstructors = superClass == null ? new MethodList.Empty() : (MethodList)superClass.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(0)).and(ElementMatchers.isVisibleTo(instrumentedType)));
                if (defaultConstructors.size() == 1) {
                    return defaultConstructors.asTokenList(ElementMatchers.is(instrumentedType));
                }
                throw new IllegalArgumentException(instrumentedType.getSuperClass() + " declares no constructor that is visible to " + instrumentedType);
            }

            @Override
            public MethodRegistry inject(MethodRegistry methodRegistry) {
                return methodRegistry.append(new LatentMatcher.Resolved(ElementMatchers.isConstructor()), new MethodRegistry.Handler.ForImplementation(SuperMethodCall.INSTANCE), MethodAttributeAppender.NoOp.INSTANCE, MethodTransformer.NoOp.INSTANCE);
            }
        }
        ,
        IMITATE_SUPER_CLASS{

            @Override
            protected List<MethodDescription.Token> doExtractConstructors(TypeDescription instrumentedType) {
                TypeDescription.Generic superClass = instrumentedType.getSuperClass();
                return (superClass == null ? new MethodList.Empty() : (MethodList)superClass.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.isVisibleTo(instrumentedType)))).asTokenList(ElementMatchers.is(instrumentedType));
            }

            @Override
            public MethodRegistry inject(MethodRegistry methodRegistry) {
                return methodRegistry.append(new LatentMatcher.Resolved(ElementMatchers.isConstructor()), new MethodRegistry.Handler.ForImplementation(SuperMethodCall.INSTANCE), MethodAttributeAppender.ForInstrumentedMethod.EXCLUDING_RECEIVER, MethodTransformer.NoOp.INSTANCE);
            }
        }
        ,
        IMITATE_SUPER_CLASS_PUBLIC{

            @Override
            protected List<MethodDescription.Token> doExtractConstructors(TypeDescription instrumentedType) {
                TypeDescription.Generic superClass = instrumentedType.getSuperClass();
                return (superClass == null ? new MethodList.Empty() : (MethodList)superClass.getDeclaredMethods().filter(ElementMatchers.isPublic().and(ElementMatchers.isConstructor()))).asTokenList(ElementMatchers.is(instrumentedType));
            }

            @Override
            public MethodRegistry inject(MethodRegistry methodRegistry) {
                return methodRegistry.append(new LatentMatcher.Resolved(ElementMatchers.isConstructor()), new MethodRegistry.Handler.ForImplementation(SuperMethodCall.INSTANCE), MethodAttributeAppender.ForInstrumentedMethod.EXCLUDING_RECEIVER, MethodTransformer.NoOp.INSTANCE);
            }
        };


        @Override
        public List<MethodDescription.Token> extractConstructors(TypeDescription instrumentedType) {
            List<MethodDescription.Token> tokens = this.doExtractConstructors(instrumentedType);
            ArrayList<MethodDescription.Token> stripped = new ArrayList<MethodDescription.Token>(tokens.size());
            for (MethodDescription.Token token : tokens) {
                stripped.add(new MethodDescription.Token(token.getName(), token.getModifiers(), token.getTypeVariableTokens(), token.getReturnType(), token.getParameterTokens(), token.getExceptionTypes(), token.getAnnotations(), token.getDefaultValue(), TypeDescription.Generic.UNDEFINED));
            }
            return stripped;
        }

        protected abstract List<MethodDescription.Token> doExtractConstructors(TypeDescription var1);

        public String toString() {
            return "ConstructorStrategy.Default." + this.name();
        }
    }
}

