/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.subscription;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.reactivestreams.Subscriber;
import reactor.rx.Stream;
import reactor.rx.action.Action;
import reactor.rx.subscription.PushSubscription;

public class DropSubscription<O>
extends PushSubscription<O> {
    protected volatile long capacity = 0L;
    protected static final AtomicLongFieldUpdater<DropSubscription> CAPACITY_UPDATER = AtomicLongFieldUpdater.newUpdater(DropSubscription.class, "capacity");

    public DropSubscription(Stream<O> publisher, Subscriber<? super O> subscriber) {
        super(publisher, subscriber);
    }

    @Override
    public void request(long elements) {
        Action.checkRequest(elements);
        CAPACITY_UPDATER.addAndGet(this, elements);
    }

    @Override
    public void cancel() {
        super.cancel();
        CAPACITY_UPDATER.set(this, 0L);
    }

    @Override
    public void onNext(O ev) {
        if (CAPACITY_UPDATER.getAndDecrement(this) > 0L) {
            this.subscriber.onNext(ev);
        } else if (CAPACITY_UPDATER.incrementAndGet(this) > 0L) {
            this.onNext(ev);
        }
    }

    @Override
    public String toString() {
        return "{capacity=" + this.capacity + (this.capacity <= 0L ? "[dropping]" : "") + '}';
    }
}

