/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.filter;

import reactor.rx.action.Action;

public class TakeAction<T>
extends Action<T, T> {
    private final long limit;
    private long counted = 0L;
    private boolean requested = false;

    public TakeAction(long limit) {
        this.limit = limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestMore(long n) {
        TakeAction takeAction = this;
        synchronized (takeAction) {
            if (!this.requested) {
                this.requested = true;
            }
        }
        super.requestMore(this.limit);
    }

    @Override
    protected void doNext(T ev) {
        this.broadcastNext(ev);
        if (++this.counted >= this.limit) {
            this.cancel();
            this.broadcastComplete();
        }
    }

    @Override
    public String toString() {
        return super.toString() + "{" + "take=" + this.limit + ", counted=" + this.counted + '}';
    }
}

