/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.misc.URIBuilder;

public class MasterSlaveServersConfig
extends BaseMasterSlaveServersConfig<MasterSlaveServersConfig> {
    private Set<URI> slaveAddresses = new HashSet<URI>();
    private List<URI> masterAddress;
    private int database = 0;

    public MasterSlaveServersConfig() {
    }

    MasterSlaveServersConfig(MasterSlaveServersConfig config) {
        super(config);
        this.setLoadBalancer(config.getLoadBalancer());
        this.setMasterAddress(config.getMasterAddress());
        this.setSlaveAddresses(config.getSlaveAddresses());
        this.setDatabase(config.getDatabase());
    }

    public MasterSlaveServersConfig setMasterAddress(String masterAddress) {
        if (masterAddress != null) {
            this.masterAddress = Collections.singletonList(URIBuilder.create(masterAddress));
        }
        return this;
    }

    public URI getMasterAddress() {
        if (this.masterAddress != null) {
            return this.masterAddress.get(0);
        }
        return null;
    }

    public void setMasterAddress(URI masterAddress) {
        if (masterAddress != null) {
            this.masterAddress = Collections.singletonList(masterAddress);
        }
    }

    public MasterSlaveServersConfig addSlaveAddress(String ... sAddresses) {
        for (String address : sAddresses) {
            this.slaveAddresses.add(URIBuilder.create(address));
        }
        return this;
    }

    public MasterSlaveServersConfig addSlaveAddress(URI slaveAddress) {
        this.slaveAddresses.add(slaveAddress);
        return this;
    }

    public Set<URI> getSlaveAddresses() {
        return this.slaveAddresses;
    }

    public void setSlaveAddresses(Set<URI> readAddresses) {
        this.slaveAddresses = readAddresses;
    }

    public MasterSlaveServersConfig setDatabase(int database) {
        this.database = database;
        return this;
    }

    public int getDatabase() {
        return this.database;
    }
}

