/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Map;
import org.redisson.api.RFuture;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.handler.CommandBatchEncoder;
import org.redisson.client.handler.CommandDecoder;
import org.redisson.client.handler.CommandEncoder;
import org.redisson.client.handler.CommandsQueue;
import org.redisson.client.handler.ConnectionWatchdog;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.misc.RedissonPromise;
import org.redisson.misc.URIBuilder;

public class RedisClient {
    private final Bootstrap bootstrap;
    private final InetSocketAddress addr;
    private final ChannelGroup channels = new DefaultChannelGroup(GlobalEventExecutor.INSTANCE);
    private final long commandTimeout;
    private Timer timer;
    private boolean hasOwnGroup;

    public RedisClient(String address) {
        this(URIBuilder.create(address));
    }

    public RedisClient(URI address) {
        this(new HashedWheelTimer(), new NioEventLoopGroup(), address);
        this.hasOwnGroup = true;
    }

    public RedisClient(Timer timer, EventLoopGroup group, URI address) {
        this(timer, group, address.getHost(), address.getPort());
    }

    public RedisClient(String host, int port) {
        this(new HashedWheelTimer(), new NioEventLoopGroup(), NioSocketChannel.class, host, port, 10000, 10000);
        this.hasOwnGroup = true;
    }

    public RedisClient(Timer timer, EventLoopGroup group, String host, int port) {
        this(timer, group, NioSocketChannel.class, host, port, 10000, 10000);
    }

    public RedisClient(final Timer timer, EventLoopGroup group, Class<? extends SocketChannel> socketChannelClass, String host, int port, int connectTimeout, int commandTimeout) {
        this.addr = new InetSocketAddress(host, port);
        this.bootstrap = ((Bootstrap)((Bootstrap)new Bootstrap().channel(socketChannelClass)).group(group)).remoteAddress(this.addr);
        this.bootstrap.handler(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addFirst(new ConnectionWatchdog(RedisClient.this.bootstrap, RedisClient.this.channels, timer), CommandEncoder.INSTANCE, CommandBatchEncoder.INSTANCE, new CommandsQueue(), new CommandDecoder());
            }
        });
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, connectTimeout);
        this.commandTimeout = commandTimeout;
    }

    public InetSocketAddress getAddr() {
        return this.addr;
    }

    public long getCommandTimeout() {
        return this.commandTimeout;
    }

    public Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    public RedisConnection connect() {
        try {
            ChannelFuture future = this.bootstrap.connect();
            future.syncUninterruptibly();
            return new RedisConnection(this, future.channel());
        }
        catch (Exception e) {
            throw new RedisConnectionException("Unable to connect to: " + this.addr, e);
        }
    }

    public RFuture<RedisConnection> connectAsync() {
        final RedissonPromise<RedisConnection> f = new RedissonPromise<RedisConnection>(ImmediateEventExecutor.INSTANCE.newPromise());
        ChannelFuture channelFuture = this.bootstrap.connect();
        channelFuture.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    RedisConnection c = new RedisConnection(RedisClient.this, future.channel());
                    f.setSuccess(c);
                } else {
                    f.setFailure(future.cause());
                }
            }
        });
        return f;
    }

    public RedisPubSubConnection connectPubSub() {
        try {
            ChannelFuture future = this.bootstrap.connect();
            future.syncUninterruptibly();
            return new RedisPubSubConnection(this, future.channel());
        }
        catch (Exception e) {
            throw new RedisConnectionException("Unable to connect to: " + this.addr, e);
        }
    }

    public RFuture<RedisPubSubConnection> connectPubSubAsync() {
        final RedissonPromise<RedisPubSubConnection> f = new RedissonPromise<RedisPubSubConnection>(ImmediateEventExecutor.INSTANCE.newPromise());
        ChannelFuture channelFuture = this.bootstrap.connect();
        channelFuture.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    RedisPubSubConnection c = new RedisPubSubConnection(RedisClient.this, future.channel());
                    f.setSuccess(c);
                } else {
                    f.setFailure(future.cause());
                }
            }
        });
        return f;
    }

    public void shutdown() {
        this.shutdownAsync().syncUninterruptibly();
        if (this.hasOwnGroup) {
            this.timer.stop();
            this.bootstrap.group().shutdownGracefully();
        }
    }

    public ChannelGroupFuture shutdownAsync() {
        for (Channel channel : this.channels) {
            ((RedisConnection)RedisConnection.getFrom(channel)).setClosed(true);
        }
        return this.channels.close();
    }

    public Map<String, String> serverInfo() {
        try {
            return (Map)this.serverInfoAsync().sync().get();
        }
        catch (Exception e) {
            throw new RedisConnectionException("Unable to retrieve server into from: " + this.addr, e);
        }
    }

    public RFuture<Map<String, String>> serverInfoAsync() {
        final RedisConnection connection = this.connect();
        RFuture<Map<String, String>> async = connection.async(RedisCommands.SERVER_INFO, new Object[0]);
        async.addListener(new FutureListener<Map<String, String>>(){

            @Override
            public void operationComplete(Future<Map<String, String>> future) throws Exception {
                connection.closeAsync();
            }
        });
        return async;
    }

    public String toString() {
        return "[addr=" + this.addr + "]";
    }
}

